@echo off
setlocal enabledelayedexpansion

echo ========================================
echo   Cloudlinker Uninstaller for Windows
echo ========================================
echo.

set "INSTALL_DIR=C:\Cloudlinker"

:: Parse arguments
:parse_args
if "%~1"=="" goto :done_args
if /i "%~1"=="--dir" (
    set "INSTALL_DIR=%~2"
    shift
    shift
    goto :parse_args
)
shift
goto :parse_args
:done_args

echo This will uninstall Cloudlinker from: %INSTALL_DIR%
echo.
set /p CONFIRM="Are you sure you want to continue? (Y/N): "
if /i not "%CONFIRM%"=="Y" (
    echo Uninstallation cancelled.
    pause
    exit /b 0
)

echo.
echo Removing Desktop shortcut...
powershell -Command "$desktop = [Environment]::GetFolderPath('Desktop'); if (Test-Path \"$desktop\Cloudlinker.lnk\") { Remove-Item \"$desktop\Cloudlinker.lnk\" }"

echo Removing Start Menu shortcut...
set "SHORTCUT_DIR=%APPDATA%\Microsoft\Windows\Start Menu\Programs"
if exist "%SHORTCUT_DIR%\Cloudlinker.lnk" (
    del "%SHORTCUT_DIR%\Cloudlinker.lnk"
)

echo Removing Startup shortcut...
set "STARTUP_DIR=%APPDATA%\Microsoft\Windows\Start Menu\Programs\Startup"
if exist "%STARTUP_DIR%\Cloudlinker.lnk" (
    del "%STARTUP_DIR%\Cloudlinker.lnk"
)

echo Removing installation directory...
if exist "%INSTALL_DIR%" (
    :: Keep config.properties backup
    if exist "%INSTALL_DIR%\config.properties" (
        echo Backing up config.properties to %USERPROFILE%\cloudlinker-config-backup.properties
        copy /Y "%INSTALL_DIR%\config.properties" "%USERPROFILE%\cloudlinker-config-backup.properties" >nul
    )
    rmdir /s /q "%INSTALL_DIR%"
)

echo.
echo ========================================
echo   Uninstallation Complete!
echo ========================================
echo.
echo Your configuration has been backed up to:
echo %USERPROFILE%\cloudlinker-config-backup.properties
echo.

pause
