@echo off
setlocal enabledelayedexpansion

echo ========================================
echo   Cloudlinker Installer for Windows
echo ========================================
echo.

:: Default installation directory
set "INSTALL_DIR=C:\Cloudlinker"

:: Parse arguments
set "ADD_STARTUP=0"
:parse_args
if "%~1"=="" goto :done_args
if /i "%~1"=="--startup" (
    set "ADD_STARTUP=1"
    shift
    goto :parse_args
)
if /i "%~1"=="--dir" (
    set "INSTALL_DIR=%~2"
    shift
    shift
    goto :parse_args
)
shift
goto :parse_args
:done_args

echo Installation directory: %INSTALL_DIR%
if "%ADD_STARTUP%"=="1" (
    echo Auto-start on boot: Yes
) else (
    echo Auto-start on boot: No (use --startup to enable^)
)
echo.

:: Minimum required Java version
set "MIN_JAVA_VER=21"

:: Check Java installation
echo Checking Java installation...
java -version >nul 2>&1
if errorlevel 1 (
    echo ERROR: Java is not installed or not in PATH.
    echo Please install Java %MIN_JAVA_VER% or higher.
    pause
    exit /b 1
)

:: Extract Java version number
set "JAVA_VER="
for /f "tokens=3" %%a in ('java -version 2^>^&1 ^| findstr /i "version"') do (
    set "JAVA_VER_RAW=%%a"
)
:: Remove quotes
set "JAVA_VER_RAW=%JAVA_VER_RAW:"=%"

:: Parse major version (handles both "21.0.1" and "1.8.0" formats)
for /f "tokens=1 delims=." %%v in ("%JAVA_VER_RAW%") do set "JAVA_MAJOR=%%v"
if "%JAVA_MAJOR%"=="1" (
    for /f "tokens=2 delims=." %%v in ("%JAVA_VER_RAW%") do set "JAVA_MAJOR=%%v"
)

echo Found Java version: %JAVA_VER_RAW% (major: %JAVA_MAJOR%)

:: Check if version meets minimum requirement
if %JAVA_MAJOR% LSS %MIN_JAVA_VER% (
    echo.
    echo ERROR: Java %JAVA_MAJOR% is too old. Cloudlinker requires Java %MIN_JAVA_VER% or higher.
    pause
    exit /b 1
)
echo Java version OK.

:: Create installation directory
echo.
echo Creating installation directory...
if not exist "%INSTALL_DIR%" (
    mkdir "%INSTALL_DIR%"
)

:: Copy files
echo Copying files...
copy /Y "%~dp0cloudlinker-1.0.jar" "%INSTALL_DIR%\" >nul
copy /Y "%~dp0lets-encrypt-root.crt" "%INSTALL_DIR%\" >nul
copy /Y "%~dp0isrgrootx1.pem" "%INSTALL_DIR%\" >nul
copy /Y "%~dp0cloudlinker.ico" "%INSTALL_DIR%\" >nul
copy /Y "%~dp0cloudlinker.png" "%INSTALL_DIR%\" >nul

:: Create config.properties if it doesn't exist
if not exist "%INSTALL_DIR%\config.properties" (
    echo Creating default configuration file...
    copy /Y "%~dp0config.properties.template" "%INSTALL_DIR%\config.properties" >nul
    echo.
    echo IMPORTANT: Please edit %INSTALL_DIR%\config.properties
    echo and fill in your organization_id and api_key.
)

:: Create launcher script
echo Creating launcher script...
(
echo @echo off
echo cd /d "%INSTALL_DIR%"
echo start "" javaw -jar cloudlinker-1.0.jar
) > "%INSTALL_DIR%\cloudlinker.bat"

:: Create Start Menu shortcut
echo Creating Start Menu shortcut...
set "SHORTCUT_DIR=%APPDATA%\Microsoft\Windows\Start Menu\Programs"
powershell -Command "$ws = New-Object -ComObject WScript.Shell; $s = $ws.CreateShortcut('%SHORTCUT_DIR%\Cloudlinker.lnk'); $s.TargetPath = '%INSTALL_DIR%\cloudlinker.bat'; $s.WorkingDirectory = '%INSTALL_DIR%'; $s.IconLocation = '%INSTALL_DIR%\cloudlinker.ico'; $s.Save()"

:: Create Desktop shortcut
echo Creating Desktop shortcut...
powershell -Command "$ws = New-Object -ComObject WScript.Shell; $desktop = [Environment]::GetFolderPath('Desktop'); $s = $ws.CreateShortcut(\"$desktop\Cloudlinker.lnk\"); $s.TargetPath = '%INSTALL_DIR%\cloudlinker.bat'; $s.WorkingDirectory = '%INSTALL_DIR%'; $s.IconLocation = '%INSTALL_DIR%\cloudlinker.ico'; $s.Save()"

:: Create Startup shortcut if requested
if "%ADD_STARTUP%"=="1" (
    echo Creating Startup shortcut for auto-start...
    set "STARTUP_DIR=%APPDATA%\Microsoft\Windows\Start Menu\Programs\Startup"
    powershell -Command "$ws = New-Object -ComObject WScript.Shell; $s = $ws.CreateShortcut('%STARTUP_DIR%\Cloudlinker.lnk'); $s.TargetPath = '%INSTALL_DIR%\cloudlinker.bat'; $s.WorkingDirectory = '%INSTALL_DIR%'; $s.IconLocation = '%INSTALL_DIR%\cloudlinker.ico'; $s.Save()"
    echo Cloudlinker will start automatically on Windows boot.
)

echo.
echo ========================================
echo   Installation Complete!
echo ========================================
echo.
echo Cloudlinker has been installed to: %INSTALL_DIR%
echo.
echo To start Cloudlinker:
echo   - Use the Desktop or Start Menu shortcut, or
echo   - Run: %INSTALL_DIR%\cloudlinker.bat
echo.
echo To configure, edit: %INSTALL_DIR%\config.properties
echo.
if "%ADD_STARTUP%"=="0" (
    echo TIP: Re-run with --startup to enable auto-start on boot.
    echo.
)

pause
