/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.renderers;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintImageAreaHyperlink;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.SimpleDimension2D;
import net.sf.jasperreports.renderers.AbstractRenderToImageAwareRenderer;
import net.sf.jasperreports.renderers.AreaHyperlinksRenderable;
import net.sf.jasperreports.renderers.BatikFontFamilyResolver;
import net.sf.jasperreports.renderers.BatikUserAgent;
import net.sf.jasperreports.renderers.DataRenderable;
import net.sf.jasperreports.renderers.DimensionRenderable;
import net.sf.jasperreports.renderers.Graphics2DRenderable;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.dom.svg.SVGDocumentFactory;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.parser.DefaultLengthHandler;
import org.apache.batik.parser.LengthParser;
import org.apache.batik.parser.ParseException;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public abstract class AbstractSvgDataToGraphics2DRenderer
extends AbstractRenderToImageAwareRenderer
implements DataRenderable,
Graphics2DRenderable,
DimensionRenderable,
AreaHyperlinksRenderable {
    private static final long serialVersionUID = 10200L;
    private List<JRPrintImageAreaHyperlink> areaHyperlinks;
    private transient SoftReference<GraphicsNode> rootNodeRef;
    private transient Dimension2D documentSize;

    protected AbstractSvgDataToGraphics2DRenderer(List<JRPrintImageAreaHyperlink> areaHyperlinks) {
        this.areaHyperlinks = areaHyperlinks;
    }

    @Override
    public Graphics2D createGraphics(BufferedImage bi) {
        Graphics2D graphics = GraphicsUtil.createGraphics(bi);
        return graphics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(JasperReportsContext jasperReportsContext, Graphics2D grx, Rectangle2D rectangle) throws JRException {
        GraphicsNode rootNode = this.getRootNode(jasperReportsContext);
        AffineTransform transform = ViewBox.getPreserveAspectRatioTransform(new float[]{0.0f, 0.0f, (float)this.documentSize.getWidth(), (float)this.documentSize.getHeight()}, (short)1, true, (float)rectangle.getWidth(), (float)rectangle.getHeight());
        Graphics2D graphics = (Graphics2D)grx.create();
        try {
            graphics.translate(rectangle.getX(), rectangle.getY());
            graphics.transform(transform);
            GraphicsNode graphicsNode = rootNode;
            synchronized (graphicsNode) {
                rootNode.paint(graphics);
            }
        }
        finally {
            graphics.dispose();
        }
    }

    @Override
    public Dimension2D getDimension(JasperReportsContext jasperReportsContext) {
        try {
            this.getRootNode(jasperReportsContext);
            return this.documentSize;
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
    }

    protected synchronized GraphicsNode getRootNode(JasperReportsContext jasperReportsContext) throws JRException {
        if (this.rootNodeRef == null || this.rootNodeRef.get() == null) {
            BatikFontFamilyResolver fontFamilyResolver = BatikFontFamilyResolver.getInstance(jasperReportsContext);
            BatikUserAgent userAgentForDoc = new BatikUserAgent(jasperReportsContext, fontFamilyResolver, 0.35277778f, null);
            SAXSVGDocumentFactory documentFactory = new SAXSVGDocumentFactory(userAgentForDoc.getXMLParserClassName(), true);
            documentFactory.setValidating(userAgentForDoc.isXMLParserValidating());
            SVGDocument document = this.getSvgDocument(jasperReportsContext, documentFactory);
            Float width = null;
            Float height = null;
            SVGSVGElement rootElement = document.getRootElement();
            if (rootElement != null) {
                RectangularShape viewBox = null;
                String viewBoxStr = rootElement.getAttributeNS(null, "viewBox");
                if (viewBoxStr != null && !viewBoxStr.isEmpty()) {
                    float[] rect = ViewBox.parseViewBoxAttribute(rootElement, viewBoxStr, null);
                    viewBox = new Rectangle2D.Float(rect[0], rect[1], rect[2], rect[3]);
                }
                width = AbstractSvgDataToGraphics2DRenderer.parseLength(rootElement, "width");
                height = AbstractSvgDataToGraphics2DRenderer.parseLength(rootElement, "height");
                if (width == null) {
                    if (height == null) {
                        if (viewBox == null) {
                            width = Float.valueOf(300.0f);
                            height = Float.valueOf(150.0f);
                        } else {
                            width = Float.valueOf((float)viewBox.getWidth());
                            height = Float.valueOf((float)viewBox.getHeight());
                        }
                    } else {
                        width = viewBox == null ? Float.valueOf(300.0f) : Float.valueOf((float)((double)height.floatValue() * viewBox.getWidth() / viewBox.getHeight()));
                    }
                } else if (height == null) {
                    height = viewBox == null ? Float.valueOf(150.0f) : Float.valueOf((float)((double)width.floatValue() * viewBox.getHeight() / viewBox.getWidth()));
                }
            }
            Node svgNode = document.getElementsByTagName("svg").item(0);
            Node svgWidthNode = svgNode.getAttributes().getNamedItem("width");
            Node svgHeightNode = svgNode.getAttributes().getNamedItem("height");
            String strSvgWidth = svgWidthNode == null ? null : svgWidthNode.getNodeValue().trim();
            String strSvgHeight = svgHeightNode == null ? null : svgHeightNode.getNodeValue().trim();
            float pixel2mm = 0.35277778f;
            if (strSvgWidth != null && strSvgWidth.endsWith("mm") || strSvgHeight != null && strSvgHeight.endsWith("mm")) {
                pixel2mm = 0.26458332f;
            }
            BatikUserAgent userAgentForCtx = new BatikUserAgent(jasperReportsContext, fontFamilyResolver, pixel2mm, width == null ? null : new SimpleDimension2D(width.floatValue(), height.floatValue()));
            BridgeContext ctx = new BridgeContext(userAgentForCtx);
            ctx.setDynamic(true);
            GVTBuilder builder = new GVTBuilder();
            GraphicsNode rootNode = builder.build(ctx, document);
            this.rootNodeRef = new SoftReference<GraphicsNode>(rootNode);
            Dimension2D svgSize = ctx.getDocumentSize();
            this.documentSize = new SimpleDimension2D(svgSize.getWidth(), svgSize.getHeight());
        }
        return this.rootNodeRef.get();
    }

    private static Float parseLength(SVGSVGElement el, String attrName) {
        String attrValue = el.getAttributeNS(null, attrName);
        if (attrValue == null || attrValue.isEmpty()) {
            return null;
        }
        final float[] value = new float[]{0.0f};
        LengthParser lp = new LengthParser();
        DefaultLengthHandler lh = new DefaultLengthHandler(){

            @Override
            public void lengthValue(float v) throws ParseException {
                value[0] = v;
            }
        };
        lp.setLengthHandler(lh);
        lp.parse(attrValue);
        return Float.valueOf(value[0]);
    }

    protected abstract SVGDocument getSvgDocument(JasperReportsContext var1, SVGDocumentFactory var2) throws JRException;

    @Override
    public List<JRPrintImageAreaHyperlink> getImageAreaHyperlinks(Rectangle2D renderingArea) throws JRException {
        return this.areaHyperlinks;
    }

    @Override
    public boolean hasImageAreaHyperlinks() {
        return this.areaHyperlinks != null && !this.areaHyperlinks.isEmpty();
    }
}

