/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.jackson.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser;
import java.io.IOException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRPropertyExpression;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignPropertyExpression;
import net.sf.jasperreports.engine.type.ExpressionTypeEnum;

public class PropertyExpressionDeserializer
extends StdDeserializer<JRPropertyExpression> {
    private static final long serialVersionUID = 1L;

    public PropertyExpressionDeserializer() {
        this((Class<?>)null);
    }

    public PropertyExpressionDeserializer(Class<?> vc) {
        super(vc);
    }

    @Override
    public JRPropertyExpression deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        FromXmlParser xp;
        ObjectCodec oc = p.getCodec();
        JsonNode node = (JsonNode)oc.readTree(p);
        JRPropertyExpression propertyExpression = null;
        FromXmlParser fromXmlParser = xp = p instanceof FromXmlParser ? (FromXmlParser)p : null;
        if (xp == null) {
            propertyExpression = this.getPropertyExpression();
            propertyExpression.setName(node.get("name").asText());
            JRDesignExpression expression = new JRDesignExpression(node.get("text").asText());
            JsonNode typeNode = node.get("type");
            if (typeNode != null) {
                expression.setType(ExpressionTypeEnum.getByName(typeNode.asText()));
            }
            this.setValueExpression(propertyExpression, expression);
        } else {
            propertyExpression = this.getPropertyExpression();
            propertyExpression.setName(node.get("name").asText());
            JRDesignExpression expression = new JRDesignExpression(node.get("").asText());
            JsonNode typeNode = node.get("type");
            if (typeNode != null) {
                expression.setType(ExpressionTypeEnum.getByName(typeNode.asText()));
            }
            this.setValueExpression(propertyExpression, expression);
        }
        return propertyExpression;
    }

    protected JRPropertyExpression getPropertyExpression() {
        return new JRDesignPropertyExpression();
    }

    protected void setValueExpression(JRPropertyExpression propetyExpression, JRExpression expression) {
        ((JRDesignPropertyExpression)propetyExpression).setValueExpression(expression);
    }
}

