/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.jackson.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.util.DefaultXmlPrettyPrinter;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.xml.stream.XMLStreamException;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameter;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameters;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentsBundle;
import net.sf.jasperreports.engine.component.ComponentsEnvironment;
import net.sf.jasperreports.engine.part.PartComponent;
import net.sf.jasperreports.engine.part.PartComponentsBundle;
import net.sf.jasperreports.engine.part.PartComponentsEnvironment;
import net.sf.jasperreports.engine.util.JRValueStringUtils;
import net.sf.jasperreports.engine.xml.ReportWriterConfiguration;
import net.sf.jasperreports.jackson.util.ColorDeserializer;
import net.sf.jasperreports.jackson.util.ColorSerializer;
import net.sf.jasperreports.jackson.util.JacksonMapping;
import net.sf.jasperreports.jackson.util.JacksonRuntimeException;
import net.sf.jasperreports.jackson.util.PropertiesMapSerializer;
import net.sf.jasperreports.jackson.util.UuidSerializer;
import org.codehaus.stax2.XMLStreamWriter2;

public class JacksonUtil {
    private static final String OBJECT_MAPPER_CONTEXT_KEY = "net.sf.jasperreports.jackson.object.mapper";
    private static final String XML_MAPPER_CONTEXT_KEY = "net.sf.jasperreports.jackson.xml.mapper";
    private final JasperReportsContext jasperReportsContext;
    private static final DefaultXmlPrettyPrinter TAB_XML_PRETTY_PRINTER = new DefaultXmlPrettyPrinter();

    protected JacksonUtil(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    public static JacksonUtil getInstance(JasperReportsContext jasperReportsContext) {
        return new JacksonUtil(jasperReportsContext);
    }

    public ObjectMapper getObjectMapper() {
        ObjectMapper mapper = (ObjectMapper)this.jasperReportsContext.getOwnValue(OBJECT_MAPPER_CONTEXT_KEY);
        if (mapper == null) {
            mapper = new ObjectMapper();
            this.configureMapper(mapper);
            this.jasperReportsContext.setValue(OBJECT_MAPPER_CONTEXT_KEY, mapper);
        }
        return mapper;
    }

    public XmlMapper getXmlMapper() {
        XmlMapper mapper = (XmlMapper)this.jasperReportsContext.getOwnValue(XML_MAPPER_CONTEXT_KEY);
        if (mapper == null) {
            mapper = new XmlMapper();
            this.configureMapper(mapper);
            this.jasperReportsContext.setValue(XML_MAPPER_CONTEXT_KEY, mapper);
        }
        return mapper;
    }

    private void configureMapper(ObjectMapper mapper) {
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        List<JacksonMapping> jacksonMappings = this.jasperReportsContext.getExtensions(JacksonMapping.class);
        for (JacksonMapping jacksonMapping : jacksonMappings) {
            JacksonUtil.register(mapper, jacksonMapping);
        }
        ComponentsEnvironment componentsEnvironment = ComponentsEnvironment.getInstance(this.jasperReportsContext);
        for (ComponentsBundle componentsBundle : componentsEnvironment.getBundles()) {
            for (Class<? extends Component> componentType : componentsBundle.getComponentTypes()) {
                mapper.registerSubtypes(componentType);
            }
        }
        PartComponentsEnvironment partComponentsEnvironment = PartComponentsEnvironment.getInstance(this.jasperReportsContext);
        for (PartComponentsBundle bundle : partComponentsEnvironment.getBundles()) {
            for (Class<? extends PartComponent> componentType : bundle.getComponentTypes()) {
                mapper.registerSubtypes(componentType);
            }
        }
        ReportWriterConfiguration reportWriterConfiguration = new ReportWriterConfiguration(this.jasperReportsContext);
        SimpleModule module = new SimpleModule();
        module.addSerializer(UUID.class, new UuidSerializer(reportWriterConfiguration.isExcludeUuids()));
        module.addSerializer(Color.class, new ColorSerializer());
        module.addDeserializer(Color.class, new ColorDeserializer());
        module.addSerializer(JRPropertiesMap.class, new PropertiesMapSerializer(reportWriterConfiguration));
        mapper.registerModule(module);
        mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
    }

    private static void register(ObjectMapper mapper, JacksonMapping mapping) {
        try {
            Class<?> clazz = Class.forName(mapping.getClassName());
            mapper.registerSubtypes(new NamedType(clazz, mapping.getName()));
        }
        catch (ClassNotFoundException e) {
            throw new JRRuntimeException(e);
        }
    }

    public <T> T loadObject(String jsonData, Class<T> clazz) {
        T result = null;
        if (jsonData != null) {
            ObjectMapper mapper = this.getObjectMapper();
            try {
                result = mapper.readValue(jsonData, clazz);
            }
            catch (JsonProcessingException e) {
                throw new JRRuntimeException(e);
            }
        }
        return result;
    }

    public <T> T loadXml(String xmlData, Class<T> clazz) {
        T result = null;
        if (xmlData != null) {
            XmlMapper mapper = this.getXmlMapper();
            try {
                result = mapper.readValue(xmlData, clazz);
            }
            catch (JsonProcessingException e) {
                throw new JRRuntimeException(e);
            }
        }
        return result;
    }

    public <T> T loadXml(InputStream is, Class<T> clazz) {
        T result = null;
        if (is != null) {
            XmlMapper mapper = this.getXmlMapper();
            try {
                result = mapper.readValue(is, clazz);
            }
            catch (JacksonException e) {
                throw new JacksonRuntimeException(e);
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
        }
        return result;
    }

    public <T> List<T> loadList(String jsonData, Class<T> clazz) {
        List result = null;
        if (jsonData != null) {
            ObjectMapper mapper = this.getObjectMapper();
            try {
                result = (List)mapper.readValue(jsonData, mapper.getTypeFactory().constructParametricType(List.class, clazz));
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
        }
        return result;
    }

    public <T> List<T> loadAsList(String jsonData, Class<T> clazz) {
        List<T> result = null;
        if (jsonData != null) {
            String trimmedData = jsonData.trim();
            if (trimmedData.startsWith("{")) {
                result = new ArrayList<T>();
                result.add(this.loadObject(trimmedData, clazz));
            } else if (trimmedData.startsWith("[")) {
                result = this.loadList(trimmedData, clazz);
            }
        }
        return result;
    }

    public String getJsonString(Object object) {
        ObjectMapper mapper = this.getObjectMapper();
        try {
            return mapper.writeValueAsString(object);
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
    }

    public String getIndentedJsonString(Object object) {
        ObjectMapper mapper = this.getObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        try {
            String string = mapper.writeValueAsString(object);
            return string;
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
        finally {
            mapper.disable(SerializationFeature.INDENT_OUTPUT);
        }
    }

    public String getXmlString(Object object) {
        XmlMapper mapper = this.getXmlMapper();
        try {
            return mapper.writer(TAB_XML_PRETTY_PRINTER).writeValueAsString(object);
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
    }

    public void writeXml(Object object, Writer writer) {
        XmlMapper mapper = this.getXmlMapper();
        try {
            mapper.writer(TAB_XML_PRETTY_PRINTER).writeValue(writer, object);
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
    }

    public ObjectNode hyperlinkToJsonObject(JRPrintHyperlink hyperlink) {
        ObjectNode hyperlinkNode = this.getObjectMapper().createObjectNode();
        this.addProperty(hyperlinkNode, "type", hyperlink.getLinkType());
        this.addProperty(hyperlinkNode, "typeValue", hyperlink.getHyperlinkType().getName());
        this.addProperty(hyperlinkNode, "target", hyperlink.getLinkTarget());
        this.addProperty(hyperlinkNode, "targetValue", hyperlink.getHyperlinkTarget().getHtmlValue(), hyperlink.getLinkTarget());
        this.addProperty(hyperlinkNode, "tooltip", hyperlink.getHyperlinkTooltip());
        this.addProperty(hyperlinkNode, "anchor", hyperlink.getHyperlinkAnchor());
        this.addProperty(hyperlinkNode, "page", String.valueOf(hyperlink.getHyperlinkPage()));
        this.addProperty(hyperlinkNode, "reference", hyperlink.getHyperlinkReference());
        JRPrintHyperlinkParameters hParams = hyperlink.getHyperlinkParameters();
        if (hParams != null && hParams.getParameters().size() > 0) {
            ObjectNode params = this.getObjectMapper().createObjectNode();
            for (JRPrintHyperlinkParameter hParam : hParams.getParameters()) {
                if (hParam.getValue() == null) continue;
                if (Collection.class.isAssignableFrom(hParam.getValue().getClass())) {
                    ArrayNode paramValues = this.getObjectMapper().createArrayNode();
                    Collection col = (Collection)hParam.getValue();
                    for (Object next : col) {
                        paramValues.add(JRValueStringUtils.serialize(next.getClass().getName(), next));
                    }
                    params.set(hParam.getName(), paramValues);
                    continue;
                }
                params.put(hParam.getName(), JRValueStringUtils.serialize(hParam.getValueClass(), hParam.getValue()));
            }
            hyperlinkNode.set("params", params);
        }
        return hyperlinkNode;
    }

    public void addProperty(ObjectNode objectNode, String property, String value) {
        this.addProperty(objectNode, property, value, null);
    }

    public void addProperty(ObjectNode objectNode, String property, String value, String altValue) {
        if (value != null && !value.equals("null")) {
            objectNode.put(property, value);
        } else if (altValue != null && !altValue.equals("null")) {
            objectNode.put(property, altValue);
        }
    }

    static {
        DefaultXmlPrettyPrinter.Indenter indenter = new DefaultXmlPrettyPrinter.Indenter(){

            @Override
            public void writeIndentation(XMLStreamWriter2 sw, int level) throws XMLStreamException {
                sw.writeRaw("\n");
                for (int i = 0; i < level; ++i) {
                    sw.writeRaw("\t");
                }
            }

            @Override
            public void writeIndentation(JsonGenerator g, int level) throws IOException {
                g.writeRaw("\n");
                for (int i = 0; i < level; ++i) {
                    g.writeRaw("\t");
                }
            }

            @Override
            public boolean isInline() {
                return false;
            }
        };
        TAB_XML_PRETTY_PRINTER.indentArraysWith(indenter);
        TAB_XML_PRETTY_PRINTER.indentObjectsWith(indenter);
    }
}

