/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.jackson.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser;
import java.io.IOException;
import net.sf.jasperreports.components.items.ItemProperty;
import net.sf.jasperreports.components.items.StandardItemProperty;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignExpression;

public class ItemPropertyDeserializer
extends StdDeserializer<ItemProperty> {
    private static final long serialVersionUID = 1L;

    public ItemPropertyDeserializer() {
        this((Class<?>)null);
    }

    public ItemPropertyDeserializer(Class<?> vc) {
        super(vc);
    }

    @Override
    public ItemProperty deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        FromXmlParser xp;
        JsonNode valueNode;
        ObjectCodec oc = p.getCodec();
        JsonNode node = (JsonNode)oc.readTree(p);
        ItemProperty itemProperty = this.getItemProperty();
        JsonNode nameNode = node.get("name");
        if (nameNode != null) {
            this.setName(itemProperty, nameNode.asText());
        }
        if ((valueNode = node.get("value")) != null) {
            this.setValue(itemProperty, valueNode.asText());
        }
        JsonNode expressionNode = null;
        FromXmlParser fromXmlParser = xp = p instanceof FromXmlParser ? (FromXmlParser)p : null;
        if (xp == null) {
            expressionNode = node.get("expression");
        } else {
            JsonNode jsonNode = expressionNode = node.getNodeType() == JsonNodeType.STRING ? node : node.get("");
        }
        if (expressionNode != null) {
            JRDesignExpression expression = new JRDesignExpression(expressionNode.asText());
            this.setValueExpression(itemProperty, expression);
        }
        this.customDeserialize(itemProperty, node);
        return itemProperty;
    }

    protected ItemProperty getItemProperty() {
        return new StandardItemProperty();
    }

    protected void setName(ItemProperty itemProperty, String name) {
        ((StandardItemProperty)itemProperty).setName(name);
    }

    protected void setValue(ItemProperty itemProperty, String value) {
        ((StandardItemProperty)itemProperty).setValue(value);
    }

    protected void setValueExpression(ItemProperty itemProperty, JRExpression expression) {
        ((StandardItemProperty)itemProperty).setValueExpression(expression);
    }

    protected void customDeserialize(ItemProperty itemProperty, JsonNode node) {
    }
}

