/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.jackson.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.type.ExpressionTypeEnum;

public class ExpressionSerializer
extends StdSerializer<JRExpression> {
    private static final long serialVersionUID = 1L;

    public ExpressionSerializer() {
        this((Class<JRExpression>)null);
    }

    public ExpressionSerializer(Class<JRExpression> vc) {
        super(vc);
    }

    @Override
    public void serialize(JRExpression value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        ToXmlGenerator xgen;
        ToXmlGenerator toXmlGenerator = xgen = jgen instanceof ToXmlGenerator ? (ToXmlGenerator)jgen : null;
        if (value.getType() == ExpressionTypeEnum.SIMPLE_TEXT) {
            if (xgen == null) {
                jgen.writeStartObject();
                jgen.writeStringField("type", ExpressionTypeEnum.SIMPLE_TEXT.getName());
                jgen.writeStringField("text", value.getText());
                jgen.writeEndObject();
            } else {
                jgen.writeStartObject();
                xgen.setNextIsAttribute(true);
                jgen.writeStringField("type", ExpressionTypeEnum.SIMPLE_TEXT.getName());
                xgen.setNextIsAttribute(false);
                jgen.writeRaw(value.getText());
                jgen.writeEndObject();
            }
        } else if (xgen == null) {
            jgen.writeString(value.getText());
        } else {
            jgen.writeStartObject();
            try {
                xgen.getStaxWriter().writeCData(value.getText());
            }
            catch (XMLStreamException e) {
                throw new IOException(e);
            }
            jgen.writeEndObject();
        }
    }
}

