/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml.print;

import java.awt.Color;
import java.io.InputStream;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.type.NamedEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XmlLoader {
    private static final Log log = LogFactory.getLog(XmlLoader.class);
    public static final String EXCEPTION_MESSAGE_KEY_UNEXPECTED_ELEMENT = "xml.print.unexpected.element";
    public static final String EXCEPTION_MESSAGE_KEY_UNEXPECTED_START_ELEMENT = "xml.print.unexpected.start.element";
    public static final String EXCEPTION_MESSAGE_KEY_UNEXPECTED_END_ELEMENT = "xml.print.unexpected.end.element";
    public static final String EXCEPTION_MESSAGE_KEY_UNEXPECTED_EVENT_TYPE = "xml.print.unexpected.event.type";
    private XMLStreamReader reader;
    private int currentElementLevel;

    public void open(InputStream is) throws JRException {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        inputFactory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
        inputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.FALSE);
        inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        try {
            this.reader = inputFactory.createXMLStreamReader(is);
        }
        catch (XMLStreamException e) {
            throw new JRRuntimeException(e);
        }
        this.currentElementLevel = 0;
    }

    protected void loadElements(Consumer<String> elementConsumer) {
        try {
            int startElementLevel = this.currentElementLevel;
            boolean ended = false;
            block7: while (!ended && this.reader.hasNext()) {
                this.reader.next();
                switch (this.reader.getEventType()) {
                    case 1: {
                        if (startElementLevel != this.currentElementLevel) {
                            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_UNEXPECTED_START_ELEMENT, this.reader.getLocalName());
                        }
                        ++this.currentElementLevel;
                        if (log.isTraceEnabled()) {
                            log.trace("start " + this.reader.getLocalName() + " level " + this.currentElementLevel);
                        }
                        elementConsumer.accept(this.reader.getLocalName());
                        continue block7;
                    }
                    case 2: {
                        if (log.isTraceEnabled()) {
                            log.trace("end " + this.reader.getLocalName() + " level " + this.currentElementLevel);
                        }
                        if (startElementLevel != this.currentElementLevel) {
                            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_UNEXPECTED_END_ELEMENT, this.reader.getLocalName());
                        }
                        --this.currentElementLevel;
                        ended = true;
                        continue block7;
                    }
                    case 4: 
                    case 8: {
                        continue block7;
                    }
                }
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_UNEXPECTED_EVENT_TYPE, this.reader.getEventType());
            }
        }
        catch (XMLStreamException e) {
            throw new JRRuntimeException(e);
        }
    }

    protected void endElement() {
        this.loadElements(this::unexpectedElement);
    }

    protected String loadText(boolean trim) {
        try {
            String text = this.reader.getElementText();
            if (log.isTraceEnabled()) {
                log.trace("loaded text from " + this.reader.getLocalName() + " level " + this.currentElementLevel);
            }
            --this.currentElementLevel;
            return text == null ? null : (trim ? text.trim() : text);
        }
        catch (XMLStreamException e) {
            throw new JRRuntimeException(e);
        }
    }

    protected void setAttribute(String name, Consumer<String> setter) {
        String value = this.getAttribute(name);
        if (value != null) {
            setter.accept(value);
        }
    }

    protected String getAttribute(String name) {
        return this.reader.getAttributeValue(null, name);
    }

    protected <T> T getAttribute(String name, Function<String, T> transform) {
        String stringValue = this.getAttribute(name);
        return stringValue != null && !stringValue.isEmpty() ? (T)transform.apply(stringValue) : null;
    }

    protected <T> void setAttribute(String name, Function<String, T> transform, Consumer<T> setter) {
        T value = this.getAttribute(name, transform);
        if (value != null) {
            setter.accept(value);
        }
    }

    protected Boolean getBooleanAttribute(String name) {
        return this.getAttribute(name, Boolean::valueOf);
    }

    protected void setBooleanAttribute(String name, Consumer<Boolean> setter) {
        this.setAttribute(name, Boolean::valueOf, setter);
    }

    protected Integer getIntAttribute(String name) {
        return this.getAttribute(name, Integer::parseInt);
    }

    protected void setIntAttribute(String name, Consumer<Integer> setter) {
        this.setAttribute(name, Integer::parseInt, setter);
    }

    protected Float getFloatAttribute(String name) {
        return this.getAttribute(name, Float::valueOf);
    }

    protected void setFloatAttribute(String name, Consumer<Float> setter) {
        this.setAttribute(name, Float::valueOf, setter);
    }

    protected <E extends NamedEnum> E getEnumAttribute(String name, Function<String, E> getByName) {
        return (E)this.getAttribute(name, getByName::apply);
    }

    protected <E extends NamedEnum> void setEnumAttribute(String name, Function<String, E> getByName, Consumer<E> setter) {
        this.setAttribute(name, getByName::apply, setter);
    }

    protected void setColorAttribute(String name, Consumer<Color> setter) {
        this.setAttribute(name, color -> JRColorUtil.getColor(color, null), setter);
    }

    protected void unexpectedElement(String element) {
        throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_UNEXPECTED_ELEMENT, element);
    }
}

