/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.rtf.RTFEditorKit;
import net.sf.jasperreports.engine.util.EditorKitMarkupProcessor;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import net.sf.jasperreports.engine.util.MarkupProcessor;
import net.sf.jasperreports.engine.util.MarkupProcessorFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RtfEditorKitMarkupProcessor
extends EditorKitMarkupProcessor {
    private static final Log log = LogFactory.getLog(RtfEditorKitMarkupProcessor.class);
    private static RtfEditorKitMarkupProcessor instance;

    public static RtfEditorKitMarkupProcessor getInstance() {
        if (instance == null) {
            instance = new RtfEditorKitMarkupProcessor();
        }
        return instance;
    }

    @Override
    public String convert(String srcText) {
        ArrayList<Element> elements = new ArrayList<Element>();
        Document document = this.getDocument(srcText);
        Element root = document.getDefaultRootElement();
        if (root != null) {
            this.addElements(elements, root);
        }
        String chunk = null;
        Element element = null;
        int startOffset = 0;
        int endOffset = 0;
        JRStyledText styledText = new JRStyledText();
        styledText.setGlobalAttributes(new HashMap<AttributedCharacterIterator.Attribute, Object>());
        for (int i = 0; i < elements.size(); ++i) {
            if (chunk != null) {
                styledText.append(chunk);
                styledText.addRun(new JRStyledText.Run(this.getAttributes(element.getAttributes()), startOffset, endOffset));
            }
            chunk = null;
            element = (Element)elements.get(i);
            startOffset = element.getStartOffset();
            endOffset = element.getEndOffset();
            try {
                chunk = document.getText(startOffset, endOffset - startOffset);
                continue;
            }
            catch (BadLocationException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Error converting markup.", e);
            }
        }
        if (chunk != null && !"\n".equals(chunk)) {
            styledText.append(chunk);
            styledText.addRun(new JRStyledText.Run(this.getAttributes(element.getAttributes()), startOffset, endOffset));
        }
        return JRStyledTextParser.getInstance().write(styledText);
    }

    @Override
    protected EditorKit getEditorKit() {
        return new RTFEditorKit();
    }

    protected void addElements(List<Element> elements, Element element) {
        if (element instanceof AbstractDocument.LeafElement) {
            elements.add(element);
        }
        for (int i = 0; i < element.getElementCount(); ++i) {
            Element child = element.getElement(i);
            this.addElements(elements, child);
        }
    }

    public static final class Factory
    implements MarkupProcessorFactory {
        @Override
        public MarkupProcessor createMarkupProcessor() {
            return RtfEditorKitMarkupProcessor.getInstance();
        }
    }
}

