/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.query.ClauseFunctionParameterHandler;
import net.sf.jasperreports.engine.query.JRClauseFunction;
import net.sf.jasperreports.engine.query.JRClauseTokens;
import net.sf.jasperreports.engine.query.JRQueryClauseContext;

public abstract class SQLLessOrGreaterBaseClause
implements JRClauseFunction {
    public static final String EXCEPTION_MESSAGE_KEY_QUERY_LESS_GREATER_CLAUSE_DB_COLUMN_TOKEN_MISSING = "query.less.greater.clause.db.column.token.missing";
    public static final String EXCEPTION_MESSAGE_KEY_QUERY_LESS_GREATER_CLAUSE_NAME_TOKEN_MISSING = "query.less.greater.clause.name.token.missing";
    public static final String EXCEPTION_MESSAGE_KEY_QUERY_LESS_GREATER_CLAUSE_PARAMETER_TOKEN_MISSING = "query.less.greater.clause.parameter.token.missing";
    protected static final int POSITION_CLAUSE_ID = 0;
    protected static final int POSITION_DB_COLUMN = 1;
    protected static final int POSITION_PARAMETER = 2;
    protected static final String OPERATOR_LESS = "<";
    protected static final String OPERATOR_LESS_OR_EQUAL = "<=";
    protected static final String OPERATOR_GREATER = ">";
    protected static final String OPERATOR_GREATER_OR_EQUAL = ">=";

    protected SQLLessOrGreaterBaseClause() {
    }

    @Override
    public void apply(JRClauseTokens clauseTokens, JRQueryClauseContext queryContext) {
        String clauseId = clauseTokens.getToken(0);
        String col = clauseTokens.getToken(1);
        String param = clauseTokens.getToken(2);
        if (clauseId == null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_QUERY_LESS_GREATER_CLAUSE_NAME_TOKEN_MISSING, (Object[])null);
        }
        if (col == null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_QUERY_LESS_GREATER_CLAUSE_DB_COLUMN_TOKEN_MISSING, (Object[])null);
        }
        if (param == null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_QUERY_LESS_GREATER_CLAUSE_PARAMETER_TOKEN_MISSING, (Object[])null);
        }
        ClauseFunctionParameterHandler paramHandler = this.createParameterHandler(queryContext, clauseId, param);
        StringBuffer sbuffer = queryContext.queryBuffer();
        if (!paramHandler.hasValue()) {
            sbuffer.append("0 = 0");
            return;
        }
        sbuffer.append(col);
        sbuffer.append(' ');
        this.handleLessOrGreaterOperator(sbuffer, clauseId);
        sbuffer.append(' ');
        sbuffer.append('?');
        paramHandler.addQueryParameter();
    }

    protected abstract ClauseFunctionParameterHandler createParameterHandler(JRQueryClauseContext var1, String var2, String var3);

    protected void handleLessOrGreaterOperator(StringBuffer sBuffer, String clauseId) {
        if ("LESS".equals(clauseId)) {
            sBuffer.append(OPERATOR_LESS);
        } else if ("LESS]".equals(clauseId)) {
            sBuffer.append(OPERATOR_LESS_OR_EQUAL);
        } else if ("GREATER".equals(clauseId)) {
            sBuffer.append(OPERATOR_GREATER);
        } else if ("[GREATER".equals(clauseId)) {
            sBuffer.append(OPERATOR_GREATER_OR_EQUAL);
        }
    }
}

