/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.part;

import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.part.PartComponent;
import net.sf.jasperreports.engine.part.PartComponentManager;
import net.sf.jasperreports.engine.part.PartComponentsBundle;
import net.sf.jasperreports.extensions.ExtensionsEnvironment;
import org.apache.commons.collections4.map.AbstractReferenceMap;
import org.apache.commons.collections4.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class PartComponentsEnvironment {
    private static final Log log = LogFactory.getLog(PartComponentsEnvironment.class);
    public static final String EXCEPTION_MESSAGE_KEY_COMPONENT_MANAGER_NOT_FOUND = "engine.part.component.manager.not.found";
    private final ReferenceMap<Object, List<PartComponentsBundle>> cache = new ReferenceMap(AbstractReferenceMap.ReferenceStrength.WEAK, AbstractReferenceMap.ReferenceStrength.HARD);
    private JasperReportsContext jasperReportsContext;

    private PartComponentsEnvironment(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    public static PartComponentsEnvironment getInstance(JasperReportsContext jasperReportsContext) {
        return new PartComponentsEnvironment(jasperReportsContext);
    }

    public Collection<PartComponentsBundle> getBundles() {
        List<PartComponentsBundle> components = this.getCachedBundles();
        return components;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<PartComponentsBundle> getCachedBundles() {
        Object cacheKey = ExtensionsEnvironment.getExtensionsCacheKey();
        ReferenceMap<Object, List<PartComponentsBundle>> referenceMap = this.cache;
        synchronized (referenceMap) {
            List<PartComponentsBundle> components = (List<PartComponentsBundle>)this.cache.get(cacheKey);
            if (components == null) {
                components = this.findBundles();
                this.cache.put(cacheKey, components);
            }
            return components;
        }
    }

    protected List<PartComponentsBundle> findBundles() {
        return this.jasperReportsContext.getExtensions(PartComponentsBundle.class);
    }

    public PartComponentManager getManager(PartComponent component) {
        List<PartComponentsBundle> bundles = this.getCachedBundles();
        List managers = bundles.stream().map(bundle -> bundle.getComponentManager(component)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        if (managers.isEmpty()) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_COMPONENT_MANAGER_NOT_FOUND, component.getClass().getName());
        }
        if (managers.size() > 1) {
            log.warn("Found " + managers.size() + " components for " + component.getClass().getName());
        }
        return (PartComponentManager)managers.get(0);
    }

    public String getComponentName(Class<? extends PartComponent> componentType) {
        for (Class<? extends PartComponent> type = componentType; type != null; type = type.getSuperclass()) {
            JsonTypeName componentSpec = type.getAnnotation(JsonTypeName.class);
            if (componentSpec == null) continue;
            return componentSpec.value();
        }
        for (Class<?> itf : componentType.getInterfaces()) {
            JsonTypeName componentSpec = itf.getAnnotation(JsonTypeName.class);
            if (componentSpec == null) continue;
            return componentSpec.value();
        }
        throw new JRRuntimeException("Cannot detect name of part component of type " + componentType.getName());
    }
}

