/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.part;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import net.sf.jasperreports.engine.BookmarkHelper;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.PrintPart;
import net.sf.jasperreports.engine.fill.BaseReportFiller;
import net.sf.jasperreports.engine.fill.DelayedFillActions;
import net.sf.jasperreports.engine.fill.JREvaluationTime;
import net.sf.jasperreports.engine.part.FillingPrintPart;
import net.sf.jasperreports.engine.part.PartPrintOutput;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FillPartPrintOutput
implements PartPrintOutput {
    private static final Log log = LogFactory.getLog(FillPartPrintOutput.class);
    private TreeMap<Integer, PrintPart> parts = new TreeMap();
    private List<JRPrintPage> pages = new ArrayList<JRPrintPage>();
    private DelayedFillActions delayedActions;
    private BookmarkHelper bookmarkHelper;
    private LinkedHashMap<String, JRStyle> styles;
    private LinkedHashSet<JROrigin> origins;

    public FillPartPrintOutput(BaseReportFiller filler) {
        this.delayedActions = new DelayedFillActions(filler);
        this.delayedActions.createDelayedEvaluationTime(JREvaluationTime.EVALUATION_TIME_MASTER);
        if (log.isDebugEnabled()) {
            log.debug(this + " created delayed actions " + this.delayedActions.getId());
        }
        if (filler.getFillContext().isCollectingBookmarks()) {
            this.bookmarkHelper = new BookmarkHelper(true);
        }
        this.styles = new LinkedHashMap();
        this.origins = new LinkedHashSet();
    }

    @Override
    public void startPart(PrintPart printPart, FillingPrintPart fillingPart) {
        int startIndex = this.pages.size();
        this.parts.put(startIndex, printPart);
        if (log.isDebugEnabled()) {
            log.debug("added part " + printPart.getName() + " at index " + startIndex);
        }
    }

    @Override
    public void addPage(JRPrintPage page, DelayedFillActions delayedActionsSource) {
        int pageIndex = this.pages.size();
        if (log.isDebugEnabled()) {
            log.debug("adding part page at index " + pageIndex);
        }
        this.pages.add(page);
        if (this.bookmarkHelper != null) {
            this.bookmarkHelper.addBookmarks(page, pageIndex);
        }
        this.delayedActions.moveMasterEvaluations(delayedActionsSource, page, pageIndex);
    }

    @Override
    public JRPrintPage getPage(int pageIndex) {
        return this.pages.get(pageIndex);
    }

    @Override
    public void pageUpdated(int partPageIndex) {
    }

    @Override
    public void append(FillPartPrintOutput output) {
        int pageOffset = this.pages.size();
        for (Map.Entry<Integer, PrintPart> partEntry : output.parts.entrySet()) {
            this.parts.put(pageOffset + partEntry.getKey(), partEntry.getValue());
        }
        ListIterator<JRPrintPage> it = output.pages.listIterator();
        while (it.hasNext()) {
            JRPrintPage page = it.next();
            this.pages.add(page);
            this.delayedActions.moveMasterEvaluations(output.delayedActions, page, pageOffset + it.previousIndex());
        }
        if (this.bookmarkHelper != null && output.bookmarkHelper != null) {
            this.bookmarkHelper.appendBookmarks(output.bookmarkHelper, pageOffset);
        }
        this.addStyles(output.styles.values());
        this.addOrigins(output.origins);
    }

    public TreeMap<Integer, PrintPart> getParts() {
        return this.parts;
    }

    public List<JRPrintPage> getPages() {
        return this.pages;
    }

    public DelayedFillActions getDelayedActions() {
        return this.delayedActions;
    }

    @Override
    public BookmarkHelper getBookmarkHelper() {
        return this.bookmarkHelper;
    }

    @Override
    public void addStyles(Collection<JRStyle> stylesList) {
        for (JRStyle style : stylesList) {
            if (this.styles.containsKey(style.getName())) {
                log.debug("style " + style.getName() + " alread present");
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug("added style " + style.getName());
            }
            this.styles.put(style.getName(), style);
        }
    }

    public Collection<JRStyle> getStyles() {
        return this.styles.values();
    }

    @Override
    public void addOrigins(Collection<JROrigin> origins) {
        this.origins.addAll(origins);
    }

    public Collection<JROrigin> getOrigins() {
        return this.origins;
    }
}

