/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fonts;

import java.awt.Font;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.fonts.AwtFontManager;
import net.sf.jasperreports.engine.fonts.FontFace;
import net.sf.jasperreports.engine.fonts.FontUtil;
import net.sf.jasperreports.engine.fonts.InvalidFontException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleFontFace
implements FontFace,
JRCloneable {
    private static final Log log = LogFactory.getLog(SimpleFontFace.class);
    private JasperReportsContext jasperReportsContext;
    private String ttf;
    private Font font;
    private String pdf;
    private String eot;
    private String svg;
    private String woff;

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
    }

    public SimpleFontFace(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    @Override
    public String getName() {
        return this.font == null ? null : this.font.getName();
    }

    @Override
    public String getTtf() {
        return this.ttf;
    }

    public void setTtf(String ttf) {
        this.setTtf(ttf, true);
    }

    public void setTtf(String ttf, boolean load) {
        this.ttf = ttf;
        this.font = null;
        if (load) {
            this.loadFont();
        }
    }

    public void loadFont() throws InvalidFontException {
        if (this.ttf != null && this.font == null) {
            String upperCaseTtf;
            if (log.isDebugEnabled()) {
                log.debug("Loading font " + this.ttf);
            }
            if ((upperCaseTtf = this.ttf.trim().toUpperCase()).endsWith(".TTF") || upperCaseTtf.endsWith(".OTF")) {
                this.font = AwtFontManager.instance().getAwtFont(this.jasperReportsContext, this.ttf);
            } else {
                FontUtil.getInstance(this.jasperReportsContext).checkAwtFont(this.ttf, JRPropertiesUtil.getInstance(this.jasperReportsContext).getBooleanProperty("net.sf.jasperreports.awt.ignore.missing.font"));
                this.font = new Font(this.ttf, 0, JRPropertiesUtil.getInstance(this.jasperReportsContext).getIntegerProperty("net.sf.jasperreports.default.font.size"));
            }
        }
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public String getPdf() {
        return this.pdf;
    }

    public void setPdf(String pdf) {
        this.pdf = pdf;
    }

    @Override
    public String getEot() {
        return this.eot;
    }

    public void setEot(String eot) {
        this.eot = eot;
    }

    @Override
    public String getSvg() {
        return this.svg;
    }

    public void setSvg(String svg) {
        this.svg = svg;
    }

    @Override
    public String getWoff() {
        return this.woff;
    }

    public void setWoff(String woff) {
        this.woff = woff;
    }

    protected void finalize() {
        AwtFontManager.instance().purgeFontFiles();
    }
}

