/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillContext;
import net.sf.jasperreports.engine.fill.JRFillSubreport;
import net.sf.jasperreports.engine.fill.JRSubreportRunner;
import net.sf.jasperreports.engine.fill.JRSubreportRunnerFactory;
import net.sf.jasperreports.engine.fill.ThreadExecutorSubreportRunner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThreadPoolSubreportRunnerFactory
implements JRSubreportRunnerFactory {
    private static final Log log = LogFactory.getLog(ThreadPoolSubreportRunnerFactory.class);
    private static final String THREAD_POOL_KEY = "net.sf.jasperreports.engine.fill.JRThreadSubreportRunner.ThreadPool";

    @Override
    public JRSubreportRunner createSubreportRunner(JRFillSubreport fillSubreport, JRBaseFiller subreportFiller) {
        JRFillContext fillContext = subreportFiller.getFillContext();
        ExecutorServiceDisposable executor = (ExecutorServiceDisposable)fillContext.getFillCache(THREAD_POOL_KEY);
        if (executor == null) {
            ExecutorService threadExecutor = this.createThreadExecutor(fillContext);
            executor = new ExecutorServiceDisposable(threadExecutor);
            fillContext.setFillCache(THREAD_POOL_KEY, executor);
        }
        return new ThreadExecutorSubreportRunner(fillSubreport, subreportFiller, executor.getExecutorService());
    }

    protected ExecutorService createThreadExecutor(JRFillContext fillContext) {
        SubreportsThreadFactory threadFactory = new SubreportsThreadFactory(fillContext);
        ExecutorService threadExecutor = Executors.newCachedThreadPool(threadFactory);
        if (log.isDebugEnabled()) {
            log.debug("created subreports thread executor " + threadExecutor + " for " + fillContext.getMasterFiller().getJasperReport().getName());
        }
        return threadExecutor;
    }

    protected static class ExecutorServiceDisposable
    implements JRFillContext.FillCacheDisposable {
        private final ExecutorService executorService;

        public ExecutorServiceDisposable(ExecutorService executorService) {
            this.executorService = executorService;
        }

        public ExecutorService getExecutorService() {
            return this.executorService;
        }

        @Override
        public void dispose() {
            if (log.isDebugEnabled()) {
                log.debug("shutting down " + this.executorService);
            }
            this.executorService.shutdownNow();
        }
    }

    protected static class SubreportsThreadFactory
    implements ThreadFactory {
        private final JRFillContext fillContext;
        private final AtomicInteger threadCount;

        public SubreportsThreadFactory(JRFillContext fillContext) {
            this.fillContext = fillContext;
            this.threadCount = new AtomicInteger();
        }

        @Override
        public Thread newThread(Runnable r) {
            String threadName = this.fillContext.getMasterFiller().getJasperReport().getName() + " subreports #" + this.threadCount.incrementAndGet();
            Thread thread = new Thread(r, threadName);
            if (log.isDebugEnabled()) {
                log.debug("created thread " + thread);
            }
            return thread;
        }
    }
}

