/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import org.apache.commons.beanutils.NestedNullException;
import org.apache.commons.beanutils.PropertyUtils;

public abstract class JRAbstractBeanDataSource
implements JRRewindableDataSource {
    public static final String EXCEPTION_MESSAGE_KEY_BEAN_FIELD_VALUE_NOT_RETRIEVED = "data.bean.field.value.not.retrieved";
    public static final String PROPERTY_JAVABEAN_FIELD_PROPERTY = "net.sf.jasperreports.javabean.field.property";
    public static final String CURRENT_BEAN_MAPPING = "_THIS";
    protected PropertyNameProvider propertyNameProvider;

    public JRAbstractBeanDataSource(boolean isUseFieldDescription) {
        this.propertyNameProvider = new DefaultPropertyNameProvider(isUseFieldDescription);
    }

    protected Object getFieldValue(Object bean, JRField field) throws JRException {
        return JRAbstractBeanDataSource.getBeanProperty(bean, this.getPropertyName(field));
    }

    public static Object getBeanProperty(Object bean, String propertyName) throws JRException {
        Object value = null;
        if (JRAbstractBeanDataSource.isCurrentBeanMapping(propertyName)) {
            value = bean;
        } else if (bean != null) {
            try {
                value = PropertyUtils.getProperty(bean, propertyName);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new JRException(EXCEPTION_MESSAGE_KEY_BEAN_FIELD_VALUE_NOT_RETRIEVED, new Object[]{propertyName}, e);
            }
            catch (NestedNullException nestedNullException) {
                // empty catch block
            }
        }
        return value;
    }

    protected static boolean isCurrentBeanMapping(String propertyName) {
        return CURRENT_BEAN_MAPPING.equals(propertyName);
    }

    protected String getPropertyName(JRField field) {
        return this.propertyNameProvider.getPropertyName(field);
    }

    public static class DefaultPropertyNameProvider
    implements PropertyNameProvider {
        private boolean isUseFieldDescription;
        private Map<String, String> fieldPropertyNames = new HashMap<String, String>();

        public DefaultPropertyNameProvider(boolean isUseFieldDescription) {
            this.isUseFieldDescription = isUseFieldDescription;
        }

        @Override
        public String getPropertyName(JRField field) {
            String fieldPropertyName = null;
            if (this.fieldPropertyNames.containsKey(field.getName())) {
                fieldPropertyName = this.fieldPropertyNames.get(field.getName());
            } else {
                if (field.hasProperties()) {
                    fieldPropertyName = field.getPropertiesMap().getProperty(JRAbstractBeanDataSource.PROPERTY_JAVABEAN_FIELD_PROPERTY);
                }
                if (fieldPropertyName == null) {
                    fieldPropertyName = this.isUseFieldDescription && field.getDescription() != null ? field.getDescription() : field.getName();
                }
                this.fieldPropertyNames.put(field.getName(), fieldPropertyName);
            }
            return fieldPropertyName;
        }
    }

    public static interface PropertyNameProvider {
        public String getPropertyName(JRField var1);
    }
}

