/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.subreport.fill;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.components.subreport.fill.ComponentFillSubreport;
import net.sf.jasperreports.components.subreport.fill.SubreportElementAdapter;
import net.sf.jasperreports.engine.DatasetRunHolder;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.component.BaseFillComponent;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.FillPrepareResult;
import net.sf.jasperreports.engine.fill.BuiltinExpressionEvaluatorFactory;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillComponentElement;
import net.sf.jasperreports.engine.fill.JRFillDatasetRun;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRTemplateFrame;
import net.sf.jasperreports.engine.fill.JRTemplatePrintFrame;
import net.sf.jasperreports.engine.fill.VirtualizableFrame;
import net.sf.jasperreports.engine.type.HorizontalPosition;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SubreportFillComponent
extends BaseFillComponent {
    private static final Log log = LogFactory.getLog(SubreportFillComponent.class);
    private final Component subreportComponent;
    protected final JRFillObjectFactory factory;
    protected ComponentFillSubreport fillSubreport;
    private boolean filling;
    protected int fillWidth;
    protected int fillWeight;
    private Map<JRStyle, JRTemplateFrame> printFrameTemplates = new HashMap<JRStyle, JRTemplateFrame>();

    public SubreportFillComponent(Component subreportComponent, JRFillObjectFactory factory) {
        this.subreportComponent = subreportComponent;
        this.factory = factory;
        JRDatasetRun datasetRun = this.getDatasetRun();
        if (datasetRun != null) {
            JRFillDatasetRun fillDatasetRun = factory.getDatasetRun(this.getDatasetRun());
            factory.registerDatasetRun(fillDatasetRun);
        }
    }

    public SubreportFillComponent(SubreportFillComponent subreportComponent, JRFillCloneFactory factory) {
        super(subreportComponent, factory);
        this.subreportComponent = subreportComponent.subreportComponent;
        this.factory = subreportComponent.factory;
        this.printFrameTemplates = subreportComponent.printFrameTemplates;
    }

    protected JRDatasetRun getDatasetRun() {
        return this.subreportComponent instanceof DatasetRunHolder ? ((DatasetRunHolder)((Object)this.subreportComponent)).getDatasetRun() : null;
    }

    @Override
    public void evaluate(byte evaluation) throws JRException {
        if (this.filling) {
            log.warn("Table fill did not complete, canceling previous table subreport");
            this.fillSubreport.cancelSubreportFill();
        }
        this.filling = false;
        if (!this.isEmpty()) {
            this.createFillSubreport();
            this.fillSubreport.evaluateSubreport(evaluation);
        }
    }

    protected void createFillSubreport() throws JRException {
        ComponentFillSubreportFactory subreportFactory = this.getFillSubreportFactory();
        if (subreportFactory == null) {
            subreportFactory = this.createFillTableSubreportFactory();
            this.setFillSubreportFactory(subreportFactory);
        }
        this.fillSubreport = subreportFactory.createFillSubreport();
    }

    public abstract ComponentFillSubreportFactory getFillSubreportFactory();

    public abstract void setFillSubreportFactory(ComponentFillSubreportFactory var1);

    public abstract JasperReport getJasperReport(BuiltinExpressionEvaluatorFactory var1) throws JRException;

    public abstract boolean isEmpty();

    protected ComponentFillSubreportFactory createFillTableSubreportFactory() throws JRException {
        BuiltinExpressionEvaluatorFactory builtinEvaluatorFactory = new BuiltinExpressionEvaluatorFactory();
        SubreportElementAdapter subreport = new SubreportElementAdapter(this.getDatasetRun(), ((JRFillComponentElement)this.fillContext.getComponentElement()).getParent());
        return new ComponentFillSubreportFactory(subreport, this.getJasperReport(builtinEvaluatorFactory), builtinEvaluatorFactory);
    }

    @Override
    public FillPrepareResult prepare(int availableHeight) {
        return this.prepare(availableHeight, true);
    }

    @Override
    public FillPrepareResult prepare(int availableHeight, boolean isOverflowAllowed) {
        try {
            if (this.isEmpty()) {
                return FillPrepareResult.NO_PRINT_NO_OVERFLOW;
            }
            JRTemplatePrintFrame printFrame = new JRTemplatePrintFrame(this.getFrameTemplate(), this.printElementOriginator);
            JRLineBox lineBox = printFrame.getLineBox();
            int verticalPadding = lineBox.getTopPadding() + lineBox.getBottomPadding();
            FillPrepareResult result = this.fillSubreport.prepareSubreport(availableHeight - verticalPadding, this.filling, isOverflowAllowed);
            if (verticalPadding != 0) {
                result = result.addStretch(verticalPadding);
            }
            this.filling = result.willOverflow();
            return result;
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
    }

    @Override
    public JRPrintElement fill() {
        Boolean shrinkWidth;
        JRTemplatePrintFrame printFrame = new JRTemplatePrintFrame(this.getFrameTemplate(), this.printElementOriginator);
        JRLineBox lineBox = printFrame.getLineBox();
        printFrame.setUUID(this.fillContext.getComponentElement().getUUID());
        printFrame.setY(this.fillContext.getElementPrintY());
        printFrame.setHeight(this.fillSubreport.getContentsStretchHeight() + lineBox.getTopPadding() + lineBox.getBottomPadding());
        List<JRStyle> styles = this.fillSubreport.getSubreportStyles();
        for (JRStyle style : styles) {
            try {
                this.fillContext.getFiller().addPrintStyle(style);
            }
            catch (JRException e) {
                throw new JRRuntimeException(e);
            }
        }
        List<JROrigin> origins = this.fillSubreport.getSubreportOrigins();
        for (JROrigin origin : origins) {
            this.fillContext.getFiller().getJasperPrint().addOrigin(origin);
        }
        int contentsWidth = this.fillWidth;
        Collection<JRPrintElement> elements = this.fillSubreport.getPrintElements();
        if (elements != null && contentsWidth < this.fillSubreport.getPrintContentsWidth()) {
            contentsWidth = this.fillSubreport.getPrintContentsWidth();
        }
        contentsWidth += lineBox.getLeftPadding() + lineBox.getRightPadding();
        int elementWidth = this.fillContext.getComponentElement().getWidth();
        int xElementsOffset = 0;
        HorizontalPosition horizontalPosition = this.getHorizontalPosition() == null ? HorizontalPosition.LEFT : this.getHorizontalPosition();
        switch (horizontalPosition) {
            case RIGHT: {
                xElementsOffset = elementWidth - contentsWidth;
                break;
            }
            case CENTER: {
                xElementsOffset = (elementWidth - contentsWidth) / 2;
                break;
            }
        }
        int xFrameOffset = 0;
        Boolean bl = shrinkWidth = this.shrinkWidth() == null ? Boolean.FALSE : this.shrinkWidth();
        if (contentsWidth < elementWidth && !shrinkWidth.booleanValue()) {
            contentsWidth = elementWidth;
        } else {
            xFrameOffset = xElementsOffset;
            xElementsOffset = 0;
        }
        printFrame.setX(this.fillContext.getComponentElement().getX() + xFrameOffset);
        printFrame.setWidth(contentsWidth);
        if (elements != null) {
            VirtualizableFrame virtualizableFrame = new VirtualizableFrame(printFrame, this.fillContext.getFiller().getVirtualizationContext(), this.fillContext.getFiller().getCurrentPage());
            virtualizableFrame.addOffsetElements(elements, xElementsOffset, 0);
            virtualizableFrame.fill();
        }
        this.fillSubreport.subreportPageFilled();
        return printFrame;
    }

    protected JRTemplateFrame getFrameTemplate() {
        JRStyle style = this.fillContext.getElementStyle();
        JRTemplateFrame frameTemplate = this.printFrameTemplates.get(style);
        if (frameTemplate == null) {
            frameTemplate = new JRTemplateFrame(this.fillContext.getElementOrigin(), this.fillContext.getDefaultStyleProvider());
            frameTemplate.setElement(this.fillContext.getComponentElement());
            frameTemplate = this.deduplicate(frameTemplate);
            this.printFrameTemplates.put(style, frameTemplate);
        }
        return frameTemplate;
    }

    @Override
    public void rewind() {
        if (this.filling) {
            if (log.isDebugEnabled()) {
                log.debug("Rewinding component subreport");
            }
            try {
                this.fillSubreport.rewind();
            }
            catch (JRException e) {
                throw new JRRuntimeException(e);
            }
            this.filling = false;
        }
    }

    protected HorizontalPosition getHorizontalPosition() {
        return null;
    }

    protected Boolean shrinkWidth() {
        return null;
    }

    public class ComponentFillSubreportFactory {
        private final JRSubreport subreport;
        private final JasperReport jasperReport;
        private final BuiltinExpressionEvaluatorFactory builtinEvaluatorFactory;

        public ComponentFillSubreportFactory(JRSubreport subreport, JasperReport jasperReport, BuiltinExpressionEvaluatorFactory builtinEvaluatorFactory) {
            this.subreport = subreport;
            this.jasperReport = jasperReport;
            this.builtinEvaluatorFactory = builtinEvaluatorFactory;
        }

        public ComponentFillSubreport createFillSubreport() {
            return new ComponentFillSubreport(SubreportFillComponent.this.fillContext, this.subreport, SubreportFillComponent.this.factory, this.jasperReport, this.builtinEvaluatorFactory);
        }
    }
}

