/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.compilers;

import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.compilers.DirectConstantEvaluator;
import net.sf.jasperreports.compilers.DirectExpressionEvaluator;
import net.sf.jasperreports.compilers.DirectExpressionEvaluators;
import net.sf.jasperreports.compilers.DirectExpressionValueFilter;
import net.sf.jasperreports.compilers.DirectFieldEvaluator;
import net.sf.jasperreports.compilers.DirectParameterEvaluator;
import net.sf.jasperreports.compilers.DirectVariableEvaluator;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.fill.JRFillField;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InterpretedExpressionEvaluators
implements DirectExpressionEvaluators {
    private static final Log log = LogFactory.getLog(InterpretedExpressionEvaluators.class);
    private DirectExpressionValueFilter valueFilter;
    private DirectConstantEvaluator nullEvaluator;
    private JREvaluator evaluator;
    private Map<String, JRFillParameter> parametersMap;
    private Map<String, JRFillField> fieldsMap;
    private Map<String, JRFillVariable> variablesMap;
    private Map<JRExpression, DirectExpressionEvaluator> evaluators;

    public InterpretedExpressionEvaluators(DirectExpressionValueFilter valueFilter) {
        this.valueFilter = valueFilter;
        this.nullEvaluator = new DirectConstantEvaluator(valueFilter.filterValue(null, null));
        this.evaluators = new HashMap<JRExpression, DirectExpressionEvaluator>();
    }

    @Override
    public void init(JREvaluator evaluator, Map<String, JRFillParameter> parametersMap, Map<String, JRFillField> fieldsMap, Map<String, JRFillVariable> variablesMap) {
        this.evaluator = evaluator;
        this.parametersMap = parametersMap;
        this.fieldsMap = fieldsMap;
        this.variablesMap = variablesMap;
        this.evaluators.clear();
    }

    @Override
    public DirectExpressionEvaluator getEvaluator(JRExpression expression) {
        if (expression.isInterpreted()) {
            DirectExpressionEvaluator evaluator = this.evaluators.get(expression);
            if (evaluator == null) {
                evaluator = this.createEvaluator(expression);
                this.evaluators.put(expression, evaluator);
            }
            return evaluator;
        }
        return null;
    }

    protected DirectExpressionEvaluator createEvaluator(JRExpression expression) {
        DirectExpressionEvaluator evaluator = null;
        JRExpressionChunk[] chunks = expression.getChunks();
        if (chunks == null || chunks.length == 0) {
            evaluator = this.nullEvaluator;
        } else if (chunks.length == 1) {
            JRExpressionChunk chunk = chunks[0];
            String chunkText = chunk.getText();
            switch (chunk.getType()) {
                case 2: {
                    JRFillParameter parameter = this.parametersMap.get(chunkText);
                    if (parameter != null) {
                        evaluator = new DirectParameterEvaluator(parameter, this.valueFilter);
                        break;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Parameter " + chunkText + " not found for interpreted expression");
                    }
                    evaluator = this.nullEvaluator;
                    break;
                }
                case 3: {
                    JRFillField field = this.fieldsMap.get(chunkText);
                    if (field != null) {
                        evaluator = new DirectFieldEvaluator(field, this.valueFilter);
                        break;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Field " + chunkText + " not found for interpreted expression");
                    }
                    evaluator = this.nullEvaluator;
                    break;
                }
                case 4: {
                    JRFillVariable variable = this.variablesMap.get(chunkText);
                    if (variable != null) {
                        evaluator = new DirectVariableEvaluator(variable, this.valueFilter);
                        break;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Variable " + chunkText + " not found for interpreted expression");
                    }
                    evaluator = this.nullEvaluator;
                    break;
                }
                case 5: {
                    Object message = this.valueFilter.filterValue(this.evaluator.str(chunkText), null);
                    evaluator = new DirectConstantEvaluator(message);
                    break;
                }
            }
        }
        if (evaluator == null) {
            throw new JRRuntimeException("Interpreted expression " + expression.getText() + " is not a simple parameter/field/variable/resource message reference.");
        }
        return evaluator;
    }
}

