/*
 * Decompiled with CFR 0.152.
 */
package eu.client.cloudlinker;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import eu.client.cloudlinker.ClientHttpResponse;
import eu.client.cloudlinker.Configuration;
import eu.client.cloudlinker.HttpService;
import eu.client.cloudlinker.Printer;
import java.awt.AWTException;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.security.KeyStore;
import java.security.cert.CertificateFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.swing.Timer;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRPrintServiceExporter;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimplePrintServiceExporterConfiguration;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.printing.PDFPageable;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.json.JSONArray;
import org.json.JSONObject;

public class Client {
    private String organization_id;
    private String api_url;
    private String api_key;
    private String client_id;
    private HttpService http_service;
    private Configuration config;
    private MqttClient mqttClient;
    private MqttConnectOptions mqttOptions;
    private SSLSocketFactory sslSocketFactory;
    private String brokerUri;
    private String brokerTopic;
    private volatile boolean isReconnecting = false;
    private static final int MAX_RECONNECT_DELAY = 60000;
    private static final int INITIAL_RECONNECT_DELAY = 1000;

    public Client(Configuration config) {
        this.config = config;
        this.http_service = new HttpService();
        this.organization_id = config.getProperty("organization_id");
        this.api_url = config.getProperty("api_url");
        this.api_key = config.getProperty("api_key");
        this.client_id = config.getProperty("client_id");
    }

    public void showNotification(String title, String message, String message_type) {
        boolean guiAvailable;
        boolean traySupported = SystemTray.isSupported();
        boolean bl = guiAvailable = !GraphicsEnvironment.isHeadless();
        if (traySupported && guiAvailable) {
            Image image = Toolkit.getDefaultToolkit().createImage("icon.png");
            TrayIcon trayIcon = new TrayIcon(image, "Cloudlinker Notification");
            trayIcon.setImageAutoSize(true);
            try {
                SystemTray tray = SystemTray.getSystemTray();
                tray.add(trayIcon);
                switch (message_type) {
                    case "info": {
                        trayIcon.displayMessage(title, message, TrayIcon.MessageType.INFO);
                        break;
                    }
                    case "warning": {
                        trayIcon.displayMessage(title, message, TrayIcon.MessageType.WARNING);
                        break;
                    }
                    case "error": {
                        trayIcon.displayMessage(title, message, TrayIcon.MessageType.ERROR);
                    }
                }
                new Timer(4000, e -> tray.remove(trayIcon)).start();
            }
            catch (AWTException aWTException) {}
        } else {
            System.out.println("Notification " + message_type + ": " + message);
        }
    }

    private Set<String> getLocalPrinters() {
        PrintService[] services;
        HashSet<String> printers = new HashSet<String>();
        for (PrintService service : services = PrintServiceLookup.lookupPrintServices(null, null)) {
            printers.add(service.getName());
            System.out.println("Printer: " + service.getName());
        }
        return printers;
    }

    private Map<String, Printer> getApiPrinters() {
        HashMap<String, Printer> printers = new HashMap<String, Printer>();
        try {
            String url = this.config.getProperty("api_url") + "devices/list";
            System.out.println("URL: " + url);
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode jsonBody = mapper.createObjectNode();
            jsonBody.put("client_id", this.client_id);
            jsonBody.put("device_type", 1);
            jsonBody.put("organization_id", this.organization_id);
            String requestBody = mapper.writeValueAsString(jsonBody);
            String result = this.http_service.performHttpRequest(url, "POST", requestBody, this.organization_id, this.api_key);
            System.out.println("API list printers result:" + result);
            JSONObject object = new JSONObject(result);
            JSONArray dataArray = object.getJSONArray("data");
            for (int i = 0; i < dataArray.length(); ++i) {
                JSONObject api_printer = dataArray.getJSONObject(i);
                String printer_name = api_printer.getString("name");
                String printer_id = api_printer.getString("id");
                printers.put(printer_name, new Printer(printer_id, printer_name));
                System.out.println("API printer:" + printer_name + " -->" + printer_id);
            }
        }
        catch (Exception ex) {
            System.err.println(ex.toString());
        }
        return printers;
    }

    private void registerPrinter(String printer_name) {
        try {
            System.out.println("Registering a new printer");
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode jsonBody = mapper.createObjectNode();
            jsonBody.put("client_id", this.client_id);
            jsonBody.put("organization_id", this.organization_id);
            jsonBody.put("name", printer_name);
            jsonBody.put("device_type", 1);
            String requestBody = mapper.writeValueAsString(jsonBody);
            System.out.println("requestBody = " + requestBody);
            String result = this.http_service.performHttpRequest(this.api_url + "devices/create", "POST", requestBody, this.organization_id, this.api_key);
            JSONObject object = new JSONObject(result);
            JSONObject data = object.getJSONObject("data");
            System.out.println(data.toString());
            if (data != null) {
                String device_id = data.getString("id");
                System.out.println("Device " + device_id + " is made");
            }
        }
        catch (Exception ex) {
            System.err.println(ex.toString());
        }
    }

    private void deletePrinter(String device_id) {
        try {
            System.out.println("Deleting a printer");
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode jsonBody = mapper.createObjectNode();
            jsonBody.put("device_id", device_id);
            String requestBody = mapper.writeValueAsString(jsonBody);
            System.out.println("requestBody = " + requestBody);
            String string = this.http_service.performHttpRequest(this.api_url + "devices/delete", "POST", requestBody, this.organization_id, this.api_key);
        }
        catch (Exception ex) {
            System.err.println(ex.toString());
        }
    }

    private void reconnectWithBackoff() {
        if (this.isReconnecting) {
            return;
        }
        this.isReconnecting = true;
        new Thread(() -> {
            int reconnectDelay = 1000;
            int attempt = 1;
            while (!this.mqttClient.isConnected()) {
                try {
                    System.out.println("Attempting to reconnect to MQTT broker (attempt " + attempt + ")...");
                    this.mqttClient.connect(this.mqttOptions);
                    this.mqttClient.subscribe(this.brokerTopic, (topic, message) -> this.handleMqttMessage(topic, message));
                    System.out.println("Successfully reconnected to MQTT broker");
                    this.showNotification("Cloudlinker", "Reconnected to MQTT broker", "info");
                    this.isReconnecting = false;
                    return;
                }
                catch (MqttException e) {
                    System.err.println("Reconnection attempt " + attempt + " failed: " + e.getMessage());
                    try {
                        Thread.sleep(reconnectDelay);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        this.isReconnecting = false;
                        return;
                    }
                    reconnectDelay = Math.min(reconnectDelay * 2, 60000);
                    ++attempt;
                }
            }
        }, "MQTT-Reconnect-Thread").start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleMqttMessage(String topic, MqttMessage message) {
        String result = new String(message.getPayload());
        System.out.println("Ontvangen JSON: " + result);
        try {
            JSONObject object = new JSONObject(result);
            String jobId = object.getString("id");
            int jobType = object.getInt("job_type");
            JSONObject payload = new JSONObject(object.getString("payload"));
            String http_callback_method = "none";
            String http_webhook_method = "GET";
            String http_webhook_url = "";
            Boolean display_client_notifications = true;
            if (payload.has("http_callback_method")) {
                http_callback_method = payload.getString("http_callback_method");
            }
            if (payload.has("http_webhook_url")) {
                http_webhook_url = payload.getString("http_webhook_url");
            }
            if (payload.has("http_webhook_method")) {
                http_webhook_method = payload.getString("http_webhook_method");
            }
            if (payload.has("display_client_notifications")) {
                display_client_notifications = payload.getBoolean("display_client_notifications");
            }
            JSONObject job_result = new JSONObject();
            ObjectMapper mapper = new ObjectMapper();
            try {
                if (jobType == 1) {
                    String deviceName = object.getString("device_name");
                    String document_url = payload.getString("document_url");
                    String document_type = payload.getString("document_type");
                    int copies = payload.getInt("copies");
                    System.out.println("URL: " + document_url + " type:" + document_type);
                    String filename = "job-" + String.valueOf(jobId) + "." + document_type;
                    this.http_service.performHttpDownload(document_url, filename);
                    if (document_type.equals("pdf")) {
                        System.out.println("Printing PDF document");
                        if (display_client_notifications.booleanValue()) {
                            this.showNotification("Cloudlinker Print Job", "Printing PDF document", "info");
                        }
                        File pdf_file = new File(filename);
                        PDDocument document = Loader.loadPDF(pdf_file);
                        PrinterJob job = PrinterJob.getPrinterJob();
                        job.setPageable(new PDFPageable(document));
                        job.setCopies(copies);
                        PrintService[] printServices = PrintServiceLookup.lookupPrintServices(null, null);
                        PrintService my_printer = null;
                        for (PrintService printService : printServices) {
                            if (!printService.getName().trim().equals(deviceName)) continue;
                            my_printer = printService;
                        }
                        job.setPrintService(my_printer);
                        job.print();
                        pdf_file.delete();
                    } else if (document_type.equals("jrprint")) {
                        JasperPrint jasperPrint;
                        System.out.println("Printing JRPRINT document");
                        File jrprintFile = new File(filename);
                        if (!jrprintFile.exists() || jrprintFile.length() == 0L) {
                            System.err.println("JRPRINT file does not exist or is empty: " + filename);
                            throw new IOException("JRPRINT file does not exist or is empty");
                        }
                        System.out.println("JRPRINT file found: " + filename);
                        try (FileInputStream fis = new FileInputStream(jrprintFile);){
                            jasperPrint = (JasperPrint)JRLoader.loadObject(fis);
                            System.out.println("JasperPrint loaded successfully.");
                        }
                        catch (IOException | JRException e) {
                            System.err.println("Failed to load JasperPrint from file: " + filename);
                            throw e;
                        }
                        PrintService[] printServices = PrintServiceLookup.lookupPrintServices(null, null);
                        PrintService myPrinter = null;
                        System.out.println("Available printers:");
                        for (PrintService ps : printServices) {
                            System.out.println(" - '" + ps.getName() + "'");
                            if (!ps.getName().trim().equalsIgnoreCase(deviceName.trim())) continue;
                            myPrinter = ps;
                        }
                        if (myPrinter == null) {
                            System.err.println("Printer not found: '" + deviceName + "'");
                            PrintService defaultPrinter = PrintServiceLookup.lookupDefaultPrintService();
                            if (defaultPrinter == null) {
                                System.err.println("No printers available.");
                                throw new Exception("No printers available");
                            }
                            System.out.println("Using default printer: '" + defaultPrinter.getName() + "'");
                            myPrinter = defaultPrinter;
                        } else {
                            System.out.println("Printer selected: '" + myPrinter.getName() + "'");
                        }
                        HashPrintRequestAttributeSet printRequestAttributes = new HashPrintRequestAttributeSet();
                        printRequestAttributes.add(new Copies(copies));
                        SimplePrintServiceExporterConfiguration exportConfig = new SimplePrintServiceExporterConfiguration();
                        exportConfig.setPrintService(myPrinter);
                        exportConfig.setPrintRequestAttributeSet(printRequestAttributes);
                        exportConfig.setDisplayPageDialog(false);
                        exportConfig.setDisplayPrintDialog(false);
                        JRPrintServiceExporter exporter = new JRPrintServiceExporter();
                        exporter.setExporterInput(new SimpleExporterInput(jasperPrint));
                        exporter.setConfiguration(exportConfig);
                        try {
                            System.out.println("Sending print job...");
                            exporter.exportReport();
                            System.out.println("Print job sent successfully to printer: " + myPrinter.getName());
                        }
                        catch (JRException e) {
                            System.err.println("Failed to export/print JasperPrint.");
                            throw e;
                        }
                        if (jrprintFile.delete()) {
                            System.out.println("Temporary JRPRINT file deleted: " + filename);
                        } else {
                            System.err.println("Could not delete JRPRINT file: " + filename);
                        }
                    }
                    job_result.put("printed", "true");
                    if (http_callback_method.equals("webhook") && !http_webhook_url.equals("")) {
                        System.out.println("Calling the webhook");
                        ObjectNode webhook_parameters_node = mapper.createObjectNode();
                        ObjectNode webhook_headers_node = mapper.createObjectNode();
                        webhook_parameters_node.put("job_id", jobId);
                        webhook_parameters_node.put("printed", true);
                        ClientHttpResponse webhook = this.http_service.performClientRequest(http_webhook_url, http_webhook_method, webhook_headers_node, webhook_parameters_node, "none", "", "", "");
                        job_result.put("webhook_http_status", webhook.statusCode);
                        job_result.put("webhook_http_result", new JSONObject(webhook.body));
                    }
                } else if (jobType == 2) {
                    Object value;
                    String key;
                    Iterator<String> keys;
                    String http_target_url = "";
                    String http_method = "";
                    String http_authenthication = "none";
                    String http_username = "";
                    String http_password = "";
                    String http_bearer_token = "";
                    if (display_client_notifications.booleanValue()) {
                        this.showNotification("Cloudlinker Http Job", "Performing HTTP request", "info");
                    }
                    ObjectNode http_parameters_node = null;
                    ObjectNode http_headers_node = null;
                    if (payload.has("http_target_url")) {
                        http_target_url = payload.getString("http_target_url");
                    }
                    if (payload.has("http_method")) {
                        http_method = payload.getString("http_method");
                    }
                    if (payload.has("http_authentication")) {
                        http_authenthication = payload.getString("http_authentication");
                    }
                    if (payload.has("http_username")) {
                        http_username = payload.getString("http_username");
                    }
                    if (payload.has("http_password")) {
                        http_password = payload.getString("http_password");
                    }
                    if (payload.has("http_bearer_token")) {
                        http_password = payload.getString("http_bearer_token");
                    }
                    if (payload.has("http_headers")) {
                        JSONObject http_headers = payload.getJSONObject("http_headers");
                        keys = http_headers.keys();
                        http_headers_node = mapper.createObjectNode();
                        while (keys.hasNext()) {
                            key = keys.next();
                            value = http_headers.get(key);
                            http_headers_node.put(key, value.toString());
                        }
                    }
                    if (payload.has("http_parameters")) {
                        JSONObject http_parameters = payload.getJSONObject("http_parameters");
                        keys = http_parameters.keys();
                        http_parameters_node = mapper.createObjectNode();
                        while (keys.hasNext()) {
                            key = keys.next();
                            value = http_parameters.get(key);
                            http_parameters_node.put(key, value.toString());
                        }
                    }
                    ClientHttpResponse chr = this.http_service.performClientRequest(http_target_url, http_method, http_headers_node, http_parameters_node, http_authenthication, http_username, http_password, http_bearer_token);
                    job_result.put("http_status", chr.statusCode);
                    job_result.put("http_result", new JSONObject(chr.body));
                    if (http_callback_method.equals("webhook") && !http_webhook_url.equals("")) {
                        System.out.println("Calling the webhook");
                        ObjectNode webhook_parameters_node = mapper.createObjectNode();
                        ObjectNode webhook_headers_node = mapper.createObjectNode();
                        webhook_parameters_node.put("job_id", jobId);
                        webhook_parameters_node.put("http_status", chr.statusCode);
                        webhook_parameters_node.put("body", chr.body);
                        ClientHttpResponse webhook = this.http_service.performClientRequest(http_webhook_url, http_webhook_method, webhook_headers_node, webhook_parameters_node, "none", "", "", "");
                        job_result.put("webhook_http_status", webhook.statusCode);
                        job_result.put("webhook_http_result", new JSONObject(webhook.body));
                    }
                }
                this.updateJob(jobId, 4, job_result.toString());
                return;
            }
            catch (Exception printError) {
                System.err.println("Error processing job " + jobId + ": " + printError.getMessage());
                printError.printStackTrace();
                job_result.put("error", printError.getMessage());
                job_result.put("error_type", printError.getClass().getName());
                this.updateJob(jobId, 5, job_result.toString());
                if (display_client_notifications == false) return;
                this.showNotification("Cloudlinker Error", "Job failed: " + printError.getMessage(), "error");
                return;
            }
        }
        catch (Exception e) {
            System.err.println("Fout bij het parsen van JSON: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void updateJob(String job_id, int status, String job_result) {
        try {
            System.out.println("Updating job " + job_id);
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode jsonBody = mapper.createObjectNode();
            jsonBody.put("job_id", job_id);
            jsonBody.put("status", status);
            jsonBody.put("result", job_result);
            String requestBody = mapper.writeValueAsString(jsonBody);
            System.out.println("requestBody = " + requestBody);
            String result = this.http_service.performHttpRequest(this.api_url + "jobs/update", "POST", requestBody, this.organization_id, this.api_key);
            JSONObject object = new JSONObject(result);
            JSONObject data = object.getJSONObject("data");
            System.out.println(data.toString());
        }
        catch (Exception ex) {
            System.err.println(ex.toString());
        }
    }

    private void registerClient() {
        try {
            System.out.println("Registering as a new client");
            InetAddress localHost = InetAddress.getLocalHost();
            String hostname = localHost.getHostName();
            String ipAddress = localHost.getHostAddress();
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode jsonBody = mapper.createObjectNode();
            jsonBody.put("hostname", hostname);
            jsonBody.put("ip_address", ipAddress);
            jsonBody.put("organization_id", this.organization_id);
            String requestBody = mapper.writeValueAsString(jsonBody);
            System.out.println("requestBody = " + requestBody);
            String result = this.http_service.performHttpRequest(this.api_url + "clients/create", "POST", requestBody, this.organization_id, this.api_key);
            JSONObject object = new JSONObject(result);
            JSONObject data = object.getJSONObject("data");
            System.out.println(result);
            if (data != null) {
                this.client_id = data.getString("id");
                this.config.setProperty("client_id", this.client_id);
                this.config.saveConfiguration();
                System.out.println("Client is made");
            }
        }
        catch (Exception ex) {
            System.err.println(ex.toString());
            System.err.println("Unable to create client with API request");
            System.exit(1);
        }
    }

    public void start() {
        try {
            if (this.client_id.isEmpty()) {
                this.registerClient();
                if (this.client_id.isEmpty()) {
                    System.exit(1);
                }
            }
            Set<String> localPrinters = this.getLocalPrinters();
            Map<String, Printer> apiPrinters = this.getApiPrinters();
            for (Printer p : apiPrinters.values()) {
                if (localPrinters.contains(p.name)) continue;
                System.out.println("Ik moet printer " + p.name + " verwijderen");
                this.deletePrinter(p.id);
            }
            for (String printer_name : localPrinters) {
                if (apiPrinters.containsKey(printer_name)) continue;
                System.out.println("Ik moet printer " + printer_name + " aanmaken");
                this.registerPrinter(printer_name);
            }
            FileInputStream caCertInput = new FileInputStream("lets-encrypt-root.crt");
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(null, null);
            trustStore.setCertificateEntry("letsencrypt", CertificateFactory.getInstance("X.509").generateCertificate(caCertInput));
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(trustStore);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, tmf.getTrustManagers(), null);
            this.sslSocketFactory = sslContext.getSocketFactory();
            this.brokerUri = "ssl://" + this.config.getProperty("server_name") + ":" + this.config.getProperty("server_port");
            this.brokerTopic = "cloudlinker/client-" + this.client_id;
            this.mqttClient = new MqttClient(this.brokerUri, this.client_id);
            this.mqttOptions = new MqttConnectOptions();
            this.mqttOptions.setCleanSession(true);
            this.mqttOptions.setUserName("cloudlinker_client");
            String password = "oTxk6Uu6K75P7{41:a[>`T!r";
            this.mqttOptions.setPassword(password.toCharArray());
            this.mqttOptions.setSocketFactory(this.sslSocketFactory);
            this.mqttOptions.setKeepAliveInterval(60);
            this.mqttOptions.setConnectionTimeout(30);
            this.mqttOptions.setAutomaticReconnect(false);
            this.mqttClient.setCallback(new MqttCallback(){

                @Override
                public void connectionLost(Throwable cause) {
                    System.err.println("MQTT connection lost: " + (cause != null ? cause.getMessage() : "Unknown reason"));
                    if (cause != null) {
                        cause.printStackTrace();
                    }
                    Client.this.showNotification("Cloudlinker", "MQTT connection lost. Reconnecting...", "warning");
                    Client.this.reconnectWithBackoff();
                }

                @Override
                public void messageArrived(String topic, MqttMessage message) throws Exception {
                    Client.this.handleMqttMessage(topic, message);
                }

                @Override
                public void deliveryComplete(IMqttDeliveryToken token) {
                }
            });
            this.mqttClient.connect(this.mqttOptions);
            this.mqttClient.subscribe(this.brokerTopic);
            System.out.println("Connected to MQTT broker: " + this.brokerUri);
            System.out.println("Subscribed to topic: " + this.brokerTopic);
        }
        catch (SSLHandshakeException e) {
            System.err.println("Handshake error");
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

