#!/bin/bash

echo "========================================"
echo "  Cloudlinker Uninstaller for Linux"
echo "========================================"
echo

INSTALL_DIR="/opt/cloudlinker"

# Parse arguments
while [[ $# -gt 0 ]]; do
    case $1 in
        --dir)
            INSTALL_DIR="$2"
            shift 2
            ;;
        *)
            shift
            ;;
    esac
done

echo "This will uninstall Cloudlinker from: $INSTALL_DIR"
echo
read -p "Are you sure you want to continue? (y/N): " CONFIRM
if [[ ! "$CONFIRM" =~ ^[Yy]$ ]]; then
    echo "Uninstallation cancelled."
    exit 0
fi

echo

# Stop and disable systemd service if exists
if [ -f "$HOME/.config/systemd/user/cloudlinker.service" ]; then
    echo "Stopping and removing systemd service..."
    systemctl --user stop cloudlinker.service 2>/dev/null || true
    systemctl --user disable cloudlinker.service 2>/dev/null || true
    rm -f "$HOME/.config/systemd/user/cloudlinker.service"
    systemctl --user daemon-reload
fi

# Remove autostart entry
echo "Removing autostart entry..."
rm -f "$HOME/.config/autostart/cloudlinker.desktop"

# Remove desktop entry
echo "Removing desktop entry..."
rm -f "$HOME/.local/share/applications/cloudlinker.desktop"

# Remove symlink
echo "Removing symlink..."
rm -f "$HOME/.local/bin/cloudlinker"

# Backup and remove installation directory
if [ -d "$INSTALL_DIR" ]; then
    if [ -f "$INSTALL_DIR/config.properties" ]; then
        echo "Backing up config.properties to ~/cloudlinker-config-backup.properties"
        cp "$INSTALL_DIR/config.properties" "$HOME/cloudlinker-config-backup.properties"
    fi
    echo "Removing installation directory..."
    rm -rf "$INSTALL_DIR"
fi

echo
echo "========================================"
echo "  Uninstallation Complete!"
echo "========================================"
echo
echo "Your configuration has been backed up to:"
echo "$HOME/cloudlinker-config-backup.properties"
echo
