/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.repo;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.Pair;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import net.sf.jasperreports.engine.xml.JRXmlWriter;
import net.sf.jasperreports.repo.DefaultReportCompiler;
import net.sf.jasperreports.repo.JasperDesignReportResource;
import net.sf.jasperreports.repo.ReportCompiler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JasperDesignCache
implements Serializable {
    private static final long serialVersionUID = 10200L;
    private static final Log log = LogFactory.getLog(JasperDesignCache.class);
    public static final String EXCEPTION_MESSAGE_KEY_INVALID_ENTRY = "repo.invalid.entry";
    private static final String PARAMETER_JASPER_DESIGN_CACHE = "net.sf.jasperreports.parameter.jasperdesign.cache";
    private JasperReportsContext jasperReportsContext;
    private ReportCompiler reportCompiler;
    private Map<String, JasperDesignReportResource> cachedResourcesMap = new ConcurrentHashMap<String, JasperDesignReportResource>();
    private Map<Pair<String, UUID>, List<JRStyle>> reportStyles = new ConcurrentHashMap<Pair<String, UUID>, List<JRStyle>>();

    public static JasperDesignCache getInstance(JasperReportsContext jasperReportsContext, ReportContext reportContext) {
        JasperDesignCache cache = null;
        if (reportContext != null && (cache = (JasperDesignCache)reportContext.getParameterValue(PARAMETER_JASPER_DESIGN_CACHE)) == null) {
            cache = new JasperDesignCache(jasperReportsContext);
            reportContext.setParameterValue(PARAMETER_JASPER_DESIGN_CACHE, cache);
        }
        return cache;
    }

    public static JasperDesignCache getExistingInstance(ReportContext reportContext) {
        JasperDesignCache cache = null;
        if (reportContext != null) {
            cache = (JasperDesignCache)reportContext.getParameterValue(PARAMETER_JASPER_DESIGN_CACHE);
        }
        return cache;
    }

    private JasperDesignCache(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
        this.reportCompiler = new DefaultReportCompiler(jasperReportsContext);
    }

    public JasperReport getJasperReport(String uri) {
        JasperDesignReportResource resource = this.getResource(uri);
        if (resource != null) {
            return resource.getReport();
        }
        return null;
    }

    public JasperDesign getJasperDesign(String uri) {
        return this.getJasperDesign(uri, true);
    }

    public JasperDesign getJasperDesign(String uri, boolean markDirty) {
        JasperDesignReportResource resource = this.getResource(uri);
        if (resource != null) {
            this.ensureJasperDesign(resource, markDirty);
            return resource.getJasperDesign();
        }
        return null;
    }

    public void set(String uri, JasperReport jasperReport) {
        JasperDesignReportResource resource = new JasperDesignReportResource();
        resource.setReport(jasperReport);
        this.cachedResourcesMap.put(uri, resource);
    }

    public void set(String uri, JasperDesign jasperDesign) {
        JasperDesignReportResource resource = new JasperDesignReportResource();
        resource.setJasperDesign(jasperDesign);
        this.cachedResourcesMap.put(uri, resource);
    }

    public void resetJasperReport(String uri) {
        JasperDesignReportResource resource = this.cachedResourcesMap.get(uri);
        if (resource != null) {
            resource.setReport(null);
        }
    }

    public JasperDesignReportResource remove(String uri) {
        return this.cachedResourcesMap.remove(uri);
    }

    public void set(String uri, JasperDesignReportResource resource) {
        this.cachedResourcesMap.put(uri, resource);
    }

    public void clear() {
        this.cachedResourcesMap.clear();
    }

    private JasperDesignReportResource getResource(String uri) {
        JasperDesignReportResource resource = this.cachedResourcesMap.get(uri);
        if (resource != null) {
            JasperDesign jasperDesign = resource.getJasperDesign();
            JasperReport jasperReport = resource.getReport();
            if (jasperReport == null && jasperDesign != null) {
                try {
                    jasperReport = this.reportCompiler.compile(jasperDesign);
                    resource.setReport(jasperReport);
                }
                catch (JRException e) {
                    throw new JRRuntimeException(e);
                }
            }
        }
        return resource;
    }

    protected void ensureJasperDesign(JasperDesignReportResource resource, boolean markDirty) {
        JasperDesign jasperDesign = resource.getJasperDesign();
        JasperReport jasperReport = resource.getReport();
        if (jasperDesign == null) {
            if (jasperReport == null) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_INVALID_ENTRY, "JasperDesignCache");
            }
            ByteArrayInputStream bais = null;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                new JRXmlWriter(this.jasperReportsContext).write((JRReport)jasperReport, baos, "UTF-8");
                bais = new ByteArrayInputStream(baos.toByteArray());
                jasperDesign = JRXmlLoader.load(bais);
                resource.setJasperDesign(jasperDesign, markDirty);
            }
            catch (JRException e) {
                throw new JRRuntimeException(e);
            }
            finally {
                try {
                    baos.close();
                    if (bais != null) {
                        bais.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        if (markDirty) {
            resource.setDesignDirty(true);
        }
    }

    public Map<String, JasperDesignReportResource> getCachedResources() {
        return this.cachedResourcesMap;
    }

    public List<JRStyle> getStyles(String reportURI, UUID id) {
        return this.reportStyles.get(new Pair<String, UUID>(reportURI, id));
    }

    public void setStyles(String reportURI, UUID id, List<JRStyle> styles) {
        if (log.isDebugEnabled()) {
            log.debug("Setting " + styles.size() + " styles for " + reportURI + " and " + id);
        }
        this.reportStyles.put(new Pair<String, UUID>(reportURI, id), styles);
    }

    public String locateReport(JasperReport jasperReport) {
        for (Map.Entry<String, JasperDesignReportResource> reportEntry : this.cachedResourcesMap.entrySet()) {
            JasperReport entryReport = reportEntry.getValue().getReport();
            if (entryReport != jasperReport) continue;
            return reportEntry.getKey();
        }
        return null;
    }

    public void setReportCompiler(ReportCompiler reportCompiler) {
        this.reportCompiler = reportCompiler;
    }
}

