/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.renderers.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.renderers.BatikUserAgent;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.dom.svg.SVGDocumentFactory;
import org.w3c.dom.svg.SVGDocument;

public class SvgDataSniffer {
    private final SVGDocumentFactory documentFactory;

    private SvgDataSniffer(JasperReportsContext jasperReportsContext) {
        BatikUserAgent userAgent = new BatikUserAgent(jasperReportsContext);
        this.documentFactory = new SAXSVGDocumentFactory(userAgent.getXMLParserClassName(), true);
        this.documentFactory.setValidating(userAgent.isXMLParserValidating());
    }

    public static SvgDataSniffer getInstance(JasperReportsContext jasperReportsContext) {
        return new SvgDataSniffer(jasperReportsContext);
    }

    public boolean isSvgData(byte[] data) {
        return this.getSvgInfo(data) != null;
    }

    public SvgInfo getSvgInfo(byte[] data) {
        try {
            SVGDocument document = this.documentFactory.createSVGDocument(null, new ByteArrayInputStream(data));
            return new SvgInfo(document.getInputEncoding());
        }
        catch (IOException e) {
            return null;
        }
    }

    public static final class SvgInfo {
        private final String encoding;

        private SvgInfo(String encoding) {
            this.encoding = encoding;
        }

        public String getEncoding() {
            return this.encoding;
        }
    }
}

