/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.renderers;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintImageAreaHyperlink;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.renderers.AbstractSvgDataToGraphics2DRenderer;
import net.sf.jasperreports.renderers.AreaHyperlinksRenderable;
import net.sf.jasperreports.renderers.DataRenderable;
import net.sf.jasperreports.renderers.RenderToImageAwareRenderable;
import org.apache.batik.dom.svg.SVGDocumentFactory;
import org.w3c.dom.svg.SVGDocument;

public class WrappingSvgDataToGraphics2DRenderer
extends AbstractSvgDataToGraphics2DRenderer {
    private static final long serialVersionUID = 10200L;
    private final DataRenderable dataRenderer;
    private final AreaHyperlinksRenderable areaHyperlinksRenderer;

    public WrappingSvgDataToGraphics2DRenderer(DataRenderable dataRenderer) {
        super(null);
        this.dataRenderer = dataRenderer;
        this.areaHyperlinksRenderer = dataRenderer instanceof AreaHyperlinksRenderable ? (AreaHyperlinksRenderable)((Object)dataRenderer) : null;
    }

    @Override
    protected SVGDocument getSvgDocument(JasperReportsContext jasperReportsContext, SVGDocumentFactory documentFactory) throws JRException {
        try {
            return documentFactory.createSVGDocument(null, new ByteArrayInputStream(this.dataRenderer.getData(jasperReportsContext)));
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
    }

    @Override
    public List<JRPrintImageAreaHyperlink> getImageAreaHyperlinks(Rectangle2D renderingArea) throws JRException {
        return this.areaHyperlinksRenderer == null ? super.getImageAreaHyperlinks(renderingArea) : this.areaHyperlinksRenderer.getImageAreaHyperlinks(renderingArea);
    }

    @Override
    public boolean hasImageAreaHyperlinks() {
        return this.areaHyperlinksRenderer == null ? super.hasImageAreaHyperlinks() : this.areaHyperlinksRenderer.hasImageAreaHyperlinks();
    }

    @Override
    public byte[] getData(JasperReportsContext jasperReportsContext) throws JRException {
        return this.dataRenderer.getData(jasperReportsContext);
    }

    @Override
    public int getImageDataDPI(JasperReportsContext jasperReportsContext) {
        if (this.dataRenderer instanceof RenderToImageAwareRenderable) {
            return ((RenderToImageAwareRenderable)((Object)this.dataRenderer)).getImageDataDPI(jasperReportsContext);
        }
        return super.getImageDataDPI(jasperReportsContext);
    }

    @Override
    public Graphics2D createGraphics(BufferedImage bi) {
        if (this.dataRenderer instanceof RenderToImageAwareRenderable) {
            return ((RenderToImageAwareRenderable)((Object)this.dataRenderer)).createGraphics(bi);
        }
        return super.createGraphics(bi);
    }
}

