/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.renderers;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintImageAreaHyperlink;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.renderers.AbstractRenderToImageAwareRenderer;
import net.sf.jasperreports.renderers.AreaHyperlinksRenderable;
import net.sf.jasperreports.renderers.DataRenderable;
import org.apache.batik.ext.awt.image.GraphicsUtil;

public class SimpleRenderToImageAwareDataRenderer
extends AbstractRenderToImageAwareRenderer
implements DataRenderable,
AreaHyperlinksRenderable {
    private static final long serialVersionUID = 10200L;
    private final byte[] data;
    private List<JRPrintImageAreaHyperlink> areaHyperlinks;
    private int minDPI;
    private boolean antiAlias;

    protected SimpleRenderToImageAwareDataRenderer(byte[] data) {
        this(data, null);
    }

    public SimpleRenderToImageAwareDataRenderer(byte[] data, List<JRPrintImageAreaHyperlink> areaHyperlinks) {
        this.data = data;
        this.areaHyperlinks = areaHyperlinks;
    }

    public static SimpleRenderToImageAwareDataRenderer getInstance(byte[] data) {
        if (data != null) {
            return new SimpleRenderToImageAwareDataRenderer(data);
        }
        return null;
    }

    @Override
    public byte[] getData(JasperReportsContext jasperReportsContext) throws JRException {
        return this.data;
    }

    @Override
    public List<JRPrintImageAreaHyperlink> getImageAreaHyperlinks(Rectangle2D renderingArea) throws JRException {
        return this.areaHyperlinks;
    }

    @Override
    public boolean hasImageAreaHyperlinks() {
        return this.areaHyperlinks != null && !this.areaHyperlinks.isEmpty();
    }

    @Override
    public int getImageDataDPI(JasperReportsContext jasperReportsContext) {
        int dpi = super.getImageDataDPI(jasperReportsContext);
        int lcMinDPI = this.getMinDPI();
        if (lcMinDPI > 0 && dpi < lcMinDPI) {
            dpi = lcMinDPI;
        }
        return dpi;
    }

    @Override
    public Graphics2D createGraphics(BufferedImage bi) {
        Graphics2D graphics = GraphicsUtil.createGraphics(bi);
        if (this.isAntiAlias()) {
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        return graphics;
    }

    public int getMinDPI() {
        return this.minDPI;
    }

    public void setMinDPI(int minDPI) {
        this.minDPI = minDPI;
    }

    public boolean isAntiAlias() {
        return this.antiAlias;
    }

    public void setAntiAlias(boolean antiAlias) {
        this.antiAlias = antiAlias;
    }
}

