/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.jackson.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRPropertyExpression;
import net.sf.jasperreports.engine.type.ExpressionTypeEnum;

public class PropertyExpressionSerializer
extends StdSerializer<JRPropertyExpression> {
    private static final long serialVersionUID = 1L;

    public PropertyExpressionSerializer() {
        this((Class<JRPropertyExpression>)null);
    }

    public PropertyExpressionSerializer(Class<JRPropertyExpression> vc) {
        super(vc);
    }

    @Override
    public void serialize(JRPropertyExpression value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        ToXmlGenerator xgen;
        ToXmlGenerator toXmlGenerator = xgen = jgen instanceof ToXmlGenerator ? (ToXmlGenerator)jgen : null;
        if (xgen == null) {
            jgen.writeStartObject();
            jgen.writeStringField("name", value.getName());
            JRExpression expression = value.getValueExpression();
            if (expression != null) {
                if (expression.getType() == ExpressionTypeEnum.SIMPLE_TEXT) {
                    jgen.writeStringField("type", ExpressionTypeEnum.SIMPLE_TEXT.getName());
                }
                jgen.writeStringField("text", expression.getText());
            }
            jgen.writeEndObject();
        } else {
            jgen.writeStartObject();
            xgen.setNextIsAttribute(true);
            jgen.writeStringField("name", value.getName());
            JRExpression expression = value.getValueExpression();
            if (expression != null) {
                if (expression.getType() == ExpressionTypeEnum.SIMPLE_TEXT) {
                    xgen.setNextIsAttribute(true);
                    jgen.writeStringField("type", ExpressionTypeEnum.SIMPLE_TEXT.getName());
                }
                xgen.setNextIsAttribute(false);
                try {
                    xgen.getStaxWriter().writeCData(expression.getText());
                }
                catch (XMLStreamException e) {
                    throw new IOException(e);
                }
            }
            jgen.writeEndObject();
        }
    }
}

