/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.jackson.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.io.IOException;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.xml.ReportWriterConfiguration;

public class PropertiesMapSerializer
extends StdSerializer<JRPropertiesMap> {
    private static final long serialVersionUID = 1L;
    private final ReportWriterConfiguration reportWriterConfig;

    public PropertiesMapSerializer(ReportWriterConfiguration reportWriterConfig) {
        super((Class)null);
        this.reportWriterConfig = reportWriterConfig;
    }

    @Override
    public boolean isUnwrappingSerializer() {
        return false;
    }

    @Override
    public void serialize(JRPropertiesMap propertiesMap, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (propertiesMap != null) {
            ToXmlGenerator xgen = jgen instanceof ToXmlGenerator ? (ToXmlGenerator)jgen : null;
            jgen.writeStartArray();
            for (String name : propertiesMap.getOwnPropertyNames()) {
                if (!this.reportWriterConfig.isPropertyToWrite(name)) continue;
                jgen.writeStartObject();
                if (xgen != null) {
                    xgen.setNextIsAttribute(true);
                }
                jgen.writeStringField("name", name);
                String value = propertiesMap.getProperty(name);
                if (value != null) {
                    jgen.writeStringField("value", value);
                }
                jgen.writeEndObject();
            }
            jgen.writeEndArray();
        }
    }
}

