/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.jackson.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser;
import java.io.IOException;
import java.util.Iterator;
import net.sf.jasperreports.engine.JRPropertiesMap;

public class PropertiesMapDeserializer
extends StdDeserializer<JRPropertiesMap> {
    private static final long serialVersionUID = 1L;

    public PropertiesMapDeserializer() {
        this((Class<?>)null);
    }

    public PropertiesMapDeserializer(Class<?> vc) {
        super(vc);
    }

    @Override
    public JRPropertiesMap deserialize(JsonParser p, DeserializationContext ctxt, JRPropertiesMap intoValue) throws IOException {
        FromXmlParser xp;
        ObjectCodec oc = p.getCodec();
        JsonNode node = (JsonNode)oc.readTree(p);
        FromXmlParser fromXmlParser = xp = p instanceof FromXmlParser ? (FromXmlParser)p : null;
        if (xp == null) {
            Iterator<JsonNode> it = node.elements();
            while (it.hasNext()) {
                JsonNode propertyNode = it.next();
                JsonNode propertyNameNode = propertyNode.get("name");
                JsonNode propertyValueNode = propertyNode.get("value");
                if (propertyNameNode == null) continue;
                intoValue.setProperty(propertyNameNode.asText(), propertyValueNode == null || propertyValueNode.isNull() ? null : propertyValueNode.asText());
            }
        } else {
            JsonNode propertyNameNode = node.get("name");
            JsonNode propertyValueNode = node.get("value");
            if (propertyNameNode != null) {
                intoValue.setProperty(propertyNameNode.asText(), propertyValueNode == null || propertyValueNode.isNull() ? null : propertyValueNode.asText());
            }
        }
        return intoValue;
    }

    @Override
    public JRPropertiesMap deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        return this.deserialize(p, ctxt, new JRPropertiesMap());
    }
}

