/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.jackson.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import net.sf.jasperreports.components.items.ItemProperty;
import net.sf.jasperreports.engine.JRExpression;

public class ItemPropertySerializer
extends StdSerializer<ItemProperty> {
    private static final long serialVersionUID = 1L;

    public ItemPropertySerializer() {
        this((Class<ItemProperty>)null);
    }

    public ItemPropertySerializer(Class<ItemProperty> vc) {
        super(vc);
    }

    @Override
    public void serialize(ItemProperty value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        ToXmlGenerator xgen;
        ToXmlGenerator toXmlGenerator = xgen = jgen instanceof ToXmlGenerator ? (ToXmlGenerator)jgen : null;
        if (xgen == null) {
            JRExpression expression;
            jgen.writeStartObject();
            jgen.writeStringField("name", value.getName());
            if (value.getValue() != null) {
                jgen.writeStringField("value", value.getValue());
            }
            if ((expression = value.getValueExpression()) != null) {
                jgen.writeStringField("expression", expression.getText());
            }
            jgen.writeEndObject();
        } else {
            JRExpression expression;
            jgen.writeStartObject();
            xgen.setNextIsAttribute(true);
            jgen.writeStringField("name", value.getName());
            if (value.getValue() != null) {
                jgen.writeStringField("value", value.getValue());
            }
            if ((expression = value.getValueExpression()) != null) {
                xgen.setNextIsAttribute(false);
                try {
                    xgen.getStaxWriter().writeCData(expression.getText());
                }
                catch (XMLStreamException e) {
                    throw new IOException(e);
                }
            }
            jgen.writeEndObject();
        }
    }
}

