/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.jackson.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser;
import java.io.IOException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.type.ExpressionTypeEnum;

public class ExpressionDeserializer
extends StdDeserializer<JRExpression> {
    private static final long serialVersionUID = 1L;

    public ExpressionDeserializer() {
        this((Class<?>)null);
    }

    public ExpressionDeserializer(Class<?> vc) {
        super(vc);
    }

    @Override
    public JRExpression deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        FromXmlParser xp;
        ObjectCodec oc = p.getCodec();
        JsonNode node = (JsonNode)oc.readTree(p);
        JRDesignExpression expression = null;
        FromXmlParser fromXmlParser = xp = p instanceof FromXmlParser ? (FromXmlParser)p : null;
        if (xp == null) {
            if (node.isObject()) {
                expression = new JRDesignExpression(node.get("text").asText());
                JsonNode typeNode = node.get("type");
                if (typeNode != null) {
                    expression.setType(ExpressionTypeEnum.getByName(typeNode.asText()));
                }
            } else {
                expression = new JRDesignExpression(node.asText());
            }
        } else if (node.isObject()) {
            expression = new JRDesignExpression(node.get("").asText());
            JsonNode typeNode = node.get("type");
            if (typeNode != null) {
                expression.setType(ExpressionTypeEnum.getByName(typeNode.asText()));
            }
        } else {
            expression = new JRDesignExpression(node.asText());
        }
        return expression;
    }
}

