/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.jackson.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import net.sf.jasperreports.engine.DatasetPropertyExpression;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.type.ExpressionTypeEnum;

public class DatasetPropertyExpressionSerializer
extends StdSerializer<DatasetPropertyExpression> {
    private static final long serialVersionUID = 1L;

    public DatasetPropertyExpressionSerializer() {
        this((Class<DatasetPropertyExpression>)null);
    }

    public DatasetPropertyExpressionSerializer(Class<DatasetPropertyExpression> vc) {
        super(vc);
    }

    @Override
    public void serialize(DatasetPropertyExpression value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        ToXmlGenerator xgen;
        ToXmlGenerator toXmlGenerator = xgen = jgen instanceof ToXmlGenerator ? (ToXmlGenerator)jgen : null;
        if (xgen == null) {
            JRExpression expression;
            jgen.writeStartObject();
            jgen.writeStringField("name", value.getName());
            if (value.getEvaluationTime() != null) {
                jgen.writeStringField("evaluationTime", value.getEvaluationTime().getName());
            }
            if ((expression = value.getValueExpression()) != null) {
                if (expression.getType() == ExpressionTypeEnum.SIMPLE_TEXT) {
                    jgen.writeStringField("type", ExpressionTypeEnum.SIMPLE_TEXT.getName());
                }
                jgen.writeStringField("text", expression.getText());
            }
            jgen.writeEndObject();
        } else {
            JRExpression expression;
            jgen.writeStartObject();
            xgen.setNextIsAttribute(true);
            jgen.writeStringField("name", value.getName());
            if (value.getEvaluationTime() != null) {
                xgen.setNextIsAttribute(true);
                jgen.writeStringField("evaluationTime", value.getEvaluationTime().getName());
            }
            if ((expression = value.getValueExpression()) != null) {
                if (expression.getType() == ExpressionTypeEnum.SIMPLE_TEXT) {
                    xgen.setNextIsAttribute(true);
                    jgen.writeStringField("type", ExpressionTypeEnum.SIMPLE_TEXT.getName());
                }
                xgen.setNextIsAttribute(false);
                try {
                    xgen.getStaxWriter().writeCData(expression.getText());
                }
                catch (XMLStreamException e) {
                    throw new IOException(e);
                }
            }
            jgen.writeEndObject();
        }
    }
}

