/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.jackson.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser;
import java.io.IOException;
import net.sf.jasperreports.engine.DatasetPropertyExpression;
import net.sf.jasperreports.engine.design.DesignDatasetPropertyExpression;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.type.ExpressionTypeEnum;
import net.sf.jasperreports.engine.type.PropertyEvaluationTimeEnum;

public class DatasetPropertyExpressionDeserializer
extends StdDeserializer<DatasetPropertyExpression> {
    private static final long serialVersionUID = 1L;

    public DatasetPropertyExpressionDeserializer() {
        this((Class<?>)null);
    }

    public DatasetPropertyExpressionDeserializer(Class<?> vc) {
        super(vc);
    }

    @Override
    public DatasetPropertyExpression deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        FromXmlParser xp;
        ObjectCodec oc = p.getCodec();
        JsonNode node = (JsonNode)oc.readTree(p);
        DesignDatasetPropertyExpression propertyExpression = null;
        FromXmlParser fromXmlParser = xp = p instanceof FromXmlParser ? (FromXmlParser)p : null;
        if (xp == null) {
            propertyExpression = new DesignDatasetPropertyExpression();
            propertyExpression.setName(node.get("name").asText());
            JsonNode evalNode = node.get("evaluationTime");
            if (evalNode != null) {
                propertyExpression.setEvaluationTime(PropertyEvaluationTimeEnum.byName(evalNode.asText()));
            }
            JRDesignExpression expression = new JRDesignExpression(node.get("text").asText());
            JsonNode typeNode = node.get("type");
            if (typeNode != null) {
                expression.setType(ExpressionTypeEnum.getByName(typeNode.asText()));
            }
            propertyExpression.setValueExpression(expression);
        } else {
            propertyExpression = new DesignDatasetPropertyExpression();
            propertyExpression.setName(node.get("name").asText());
            JsonNode evalNode = node.get("evaluationTime");
            if (evalNode != null) {
                propertyExpression.setEvaluationTime(PropertyEvaluationTimeEnum.byName(evalNode.asText()));
            }
            JRDesignExpression expression = new JRDesignExpression(node.get("").asText());
            JsonNode typeNode = node.get("type");
            if (typeNode != null) {
                expression.setType(ExpressionTypeEnum.getByName(typeNode.asText()));
            }
            propertyExpression.setValueExpression(expression);
        }
        return propertyExpression;
    }
}

