/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBasePrintHyperlink;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.util.EditorKitMarkupProcessor;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import net.sf.jasperreports.engine.util.JRTextAttribute;
import net.sf.jasperreports.engine.util.MarkupProcessor;
import net.sf.jasperreports.engine.util.MarkupProcessorFactory;
import net.sf.jasperreports.engine.util.StyledTextListInfo;
import net.sf.jasperreports.engine.util.StyledTextListItemInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HtmlEditorKitMarkupProcessor
extends EditorKitMarkupProcessor {
    private static final Log log = LogFactory.getLog(HtmlEditorKitMarkupProcessor.class);
    private Document document;
    private boolean bodyOccurred = false;
    private boolean isFirstContentTag = true;
    private boolean breaksFlow = false;
    private boolean suppressBreaksFlow = false;
    private int rootEndOffset;
    private Stack<StyledTextListInfo> htmlListStack;
    private boolean insideLi;
    private boolean liStart;
    private StyledTextListInfo justClosedList;

    @Override
    public String convert(String srcText) {
        if (srcText.indexOf(60) >= 0 || srcText.indexOf(38) >= 0) {
            JRStyledText styledText = new JRStyledText();
            this.document = this.getDocument(srcText);
            this.bodyOccurred = false;
            this.isFirstContentTag = true;
            this.breaksFlow = false;
            this.suppressBreaksFlow = false;
            this.rootEndOffset = 0;
            this.htmlListStack = new Stack();
            this.insideLi = false;
            this.liStart = false;
            this.justClosedList = null;
            Element root = this.document.getDefaultRootElement();
            if (root != null) {
                this.rootEndOffset = root.getEndOffset();
                this.processElement(styledText, root);
            }
            styledText.setGlobalAttributes(new HashMap<AttributedCharacterIterator.Attribute, Object>());
            return JRStyledTextParser.getInstance().write(styledText);
        }
        return srcText;
    }

    @Override
    protected EditorKit getEditorKit() {
        return new HTMLEditorKit();
    }

    private void processElement(JRStyledText styledText, Element parentElement) {
        for (int i = 0; i < parentElement.getElementCount(); ++i) {
            HTML.Tag htmlTag;
            Element element = parentElement.getElement(i);
            AttributeSet attrs = element.getAttributes();
            Object elementName = attrs.getAttribute("$ename");
            Object object = elementName != null ? null : attrs.getAttribute(StyleConstants.NameAttribute);
            HTML.Tag tag = htmlTag = object instanceof HTML.Tag ? (HTML.Tag)object : null;
            if (htmlTag == null) continue;
            this.suppressBreaksFlow |= htmlTag == HTML.Tag.UL || htmlTag == HTML.Tag.OL || htmlTag == HTML.Tag.LI;
            this.breaksFlow |= !element.isLeaf() && htmlTag.breaksFlow() || htmlTag == HTML.Tag.IMPLIED;
            if (htmlTag == HTML.Tag.BODY) {
                this.bodyOccurred = true;
                this.processElement(styledText, element);
            } else if (htmlTag == HTML.Tag.BR) {
                if (this.bodyOccurred && !this.isFirstContentTag && this.breaksFlow && !this.suppressBreaksFlow && i == 0) {
                    styledText.append("\n");
                    this.resizeRuns(styledText.getRuns(), styledText.length(), 1);
                }
                if (element.getEndOffset() != this.rootEndOffset - 1) {
                    styledText.append("\n");
                    int startIndex = styledText.length();
                    this.resizeRuns(styledText.getRuns(), startIndex, 1);
                    this.processElement(styledText, element);
                    styledText.addRun(new JRStyledText.Run(new HashMap<AttributedCharacterIterator.Attribute, Object>(), startIndex, styledText.length()));
                    if (startIndex < styledText.length()) {
                        styledText.append("\n");
                        this.resizeRuns(styledText.getRuns(), startIndex, 1);
                    }
                    this.breaksFlow = false;
                    this.suppressBreaksFlow = true;
                }
            } else if (htmlTag == HTML.Tag.OL || htmlTag == HTML.Tag.UL) {
                Object type = attrs.getAttribute(HTML.Attribute.TYPE);
                Object start = attrs.getAttribute(HTML.Attribute.START);
                StyledTextListInfo htmlList = new StyledTextListInfo(htmlTag == HTML.Tag.OL, htmlTag == HTML.Tag.OL && type != null ? String.valueOf(type) : null, htmlTag == HTML.Tag.OL && start != null ? Integer.valueOf(start.toString()) : null, this.insideLi);
                htmlList.setAtLiStart(this.liStart);
                this.htmlListStack.push(htmlList);
                this.insideLi = false;
                HashMap<AttributedCharacterIterator.Attribute, Object> styleAttrs = new HashMap<AttributedCharacterIterator.Attribute, Object>();
                styleAttrs.put(JRTextAttribute.HTML_LIST, this.htmlListStack.toArray(new StyledTextListInfo[this.htmlListStack.size()]));
                styleAttrs.put(JRTextAttribute.HTML_LIST_ITEM, StyledTextListItemInfo.NO_LIST_ITEM_FILLER);
                int startIndex = styledText.length();
                this.processElement(styledText, element);
                styledText.addRun(new JRStyledText.Run(styleAttrs, startIndex, styledText.length()));
                this.justClosedList = this.htmlListStack.pop();
            } else if (htmlTag == HTML.Tag.LI) {
                HashMap<AttributedCharacterIterator.Attribute, Object> styleAttrs = new HashMap<AttributedCharacterIterator.Attribute, Object>();
                StyledTextListInfo htmlList = null;
                boolean ulAdded = false;
                if (this.htmlListStack.size() == 0) {
                    htmlList = new StyledTextListInfo(false, null, null, false);
                    this.htmlListStack.push(htmlList);
                    styleAttrs.put(JRTextAttribute.HTML_LIST, this.htmlListStack.toArray(new StyledTextListInfo[this.htmlListStack.size()]));
                    styleAttrs.put(JRTextAttribute.HTML_LIST_ITEM, StyledTextListItemInfo.NO_LIST_ITEM_FILLER);
                    ulAdded = true;
                } else {
                    htmlList = this.htmlListStack.peek();
                }
                htmlList.setItemCount(htmlList.getItemCount() + 1);
                this.insideLi = true;
                this.liStart = true;
                this.justClosedList = null;
                styleAttrs.put(JRTextAttribute.HTML_LIST_ITEM, new StyledTextListItemInfo(htmlList.getItemCount() - 1));
                int startIndex = styledText.length();
                this.processElement(styledText, element);
                styledText.addRun(new JRStyledText.Run(styleAttrs, startIndex, styledText.length()));
                this.insideLi = false;
                this.liStart = false;
                if (this.justClosedList != null) {
                    this.justClosedList.setAtLiEnd(true);
                }
                if (ulAdded) {
                    this.htmlListStack.pop();
                }
            } else if (htmlTag == HTML.Tag.CONTENT) {
                String chunk;
                block30: {
                    chunk = null;
                    try {
                        chunk = this.document.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
                    }
                    catch (BadLocationException e) {
                        if (!log.isDebugEnabled()) break block30;
                        log.debug("Error converting markup.", e);
                    }
                }
                if (chunk != null && !"\n".equals(chunk)) {
                    HTMLDocument.RunElement runElement;
                    AttributeSet attrSet;
                    if (this.bodyOccurred && !this.isFirstContentTag && this.breaksFlow && !this.suppressBreaksFlow) {
                        styledText.append("\n");
                        this.resizeRuns(styledText.getRuns(), styledText.length(), 1);
                    }
                    this.isFirstContentTag = false;
                    this.breaksFlow = false;
                    this.suppressBreaksFlow = false;
                    this.liStart = false;
                    this.justClosedList = null;
                    int startIndex = styledText.length();
                    styledText.append(chunk);
                    Map<AttributedCharacterIterator.Attribute, Object> styleAttributes = this.getAttributes(element.getAttributes());
                    if (element instanceof HTMLDocument.RunElement && (attrSet = (AttributeSet)(runElement = (HTMLDocument.RunElement)element).getAttribute(HTML.Tag.A)) != null) {
                        JRBasePrintHyperlink hyperlink = new JRBasePrintHyperlink();
                        hyperlink.setHyperlinkType(HyperlinkTypeEnum.REFERENCE);
                        hyperlink.setHyperlinkReference((String)attrSet.getAttribute(HTML.Attribute.HREF));
                        hyperlink.setLinkTarget((String)attrSet.getAttribute(HTML.Attribute.TARGET));
                        styleAttributes.put(JRTextAttribute.HYPERLINK, hyperlink);
                    }
                    styledText.addRun(new JRStyledText.Run(styleAttributes, startIndex, styledText.length()));
                }
            } else if (htmlTag == HTML.Tag.P && element.getElementCount() == 1) {
                HTML.Tag pChildHtmlTag;
                Element pChildElement = element.getElement(0);
                AttributeSet pChildAttrs = pChildElement.getAttributes();
                Object pChildElementName = pChildAttrs.getAttribute("$ename");
                Object pChildObject = pChildElementName != null ? null : pChildAttrs.getAttribute(StyleConstants.NameAttribute);
                HTML.Tag tag2 = pChildHtmlTag = object instanceof HTML.Tag ? (HTML.Tag)pChildObject : null;
                if (pChildHtmlTag == HTML.Tag.CONTENT) {
                    String chunk;
                    block31: {
                        chunk = null;
                        try {
                            chunk = this.document.getText(pChildElement.getStartOffset(), pChildElement.getEndOffset() - pChildElement.getStartOffset());
                        }
                        catch (BadLocationException e) {
                            if (!log.isDebugEnabled()) break block31;
                            log.debug("Error converting markup.", e);
                        }
                    }
                    if ("\n".equals(chunk)) {
                        styledText.append("\n");
                        this.resizeRuns(styledText.getRuns(), styledText.length(), 1);
                    }
                }
            } else if (this.bodyOccurred) {
                this.processElement(styledText, element);
            }
            this.suppressBreaksFlow |= htmlTag == HTML.Tag.UL || htmlTag == HTML.Tag.OL || htmlTag == HTML.Tag.LI;
        }
    }

    private void resizeRuns(List<JRStyledText.Run> runs, int startIndex, int count) {
        for (int j = 0; j < runs.size(); ++j) {
            JRStyledText.Run run = runs.get(j);
            if (run.startIndex > startIndex || run.endIndex <= startIndex - count) continue;
            run.endIndex += count;
        }
    }

    protected static String getOLBulletChars(int index, boolean isUpperCase) {
        if (index < 0 || index > 18277) {
            throw new JRRuntimeException("util.markup.processor.number.outside.bounds", index);
        }
        return JRStringUtil.getLetterNumeral(index, isUpperCase);
    }

    public static final class Factory
    implements MarkupProcessorFactory {
        @Override
        public MarkupProcessor createMarkupProcessor() {
            return new HtmlEditorKitMarkupProcessor();
        }
    }
}

