/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import java.util.TimeZone;
import javax.sql.rowset.CachedRowSet;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRResultSetDataSource;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.query.JRAbstractQueryExecuter;
import net.sf.jasperreports.engine.query.ProcedureCallHandler;
import net.sf.jasperreports.engine.query.ProcedureCallHandlerFactory;
import net.sf.jasperreports.engine.util.JRSingletonCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRJdbcQueryExecuter
extends JRAbstractQueryExecuter {
    private static final Log log = LogFactory.getLog(JRJdbcQueryExecuter.class);
    public static final String EXCEPTION_MESSAGE_KEY_MULTI_PARAMETERS_CANNOT_CONTAIN_NULL_VALUES = "query.multi.parameters.cannot.contain.null.values";
    public static final String EXCEPTION_MESSAGE_KEY_QUERY_STATEMENT_CANCEL_ERROR = "query.statement.cancel.error";
    public static final String EXCEPTION_MESSAGE_KEY_QUERY_STATEMENT_EXECUTE_ERROR = "query.statement.execute.error";
    public static final String EXCEPTION_MESSAGE_KEY_QUERY_STATEMENT_PREPARE_ERROR = "query.statement.prepare.error";
    public static final String EXCEPTION_MESSAGE_KEY_QUERY_STATEMENT_TIMEOUT_LIMIT_EXCEEDED = "query.statement.timeout.limit.exceeded";
    public static final String EXCEPTION_MESSAGE_KEY_UNEXPECTED_MULTI_PARAMETER_TYPE = "query.unexpected.multi.parameter.type";
    public static final String CANONICAL_LANGUAGE = "SQL";
    public static final String CLAUSE_ID_IN = "IN";
    public static final String CLAUSE_ID_NOTIN = "NOTIN";
    public static final String CLAUSE_ID_EQUAL = "EQUAL";
    public static final String CLAUSE_ID_NOTEQUAL = "NOTEQUAL";
    public static final String CLAUSE_ID_LESS = "LESS";
    public static final String CLAUSE_ID_GREATER = "GREATER";
    public static final String CLAUSE_ID_LESS_OR_EQUAL = "LESS]";
    public static final String CLAUSE_ID_GREATER_OR_EQUAL = "[GREATER";
    public static final String CLAUSE_ID_BETWEEN = "BETWEEN";
    public static final String CLAUSE_ID_BETWEEN_CLOSED = "[BETWEEN]";
    public static final String CLAUSE_ID_BETWEEN_LEFT_CLOSED = "[BETWEEN";
    public static final String CLAUSE_ID_BETWEEN_RIGHT_CLOSED = "BETWEEN]";
    protected static final String TYPE_FORWARD_ONLY = "forwardOnly";
    protected static final String TYPE_SCROLL_INSENSITIVE = "scrollInsensitive";
    protected static final String TYPE_SCROLL_SENSITIVE = "scrollSensitive";
    protected static final String CONCUR_READ_ONLY = "readOnly";
    protected static final String CONCUR_UPDATABLE = "updatable";
    protected static final String HOLD_CURSORS_OVER_COMMIT = "hold";
    protected static final String CLOSE_CURSORS_AT_COMMIT = "close";
    protected static final String CACHED_ROWSET_CLASS = "com.sun.rowset.CachedRowSetImpl";
    private static final JRSingletonCache<ProcedureCallHandlerFactory> procedureCallHandlerFactoryCache = new JRSingletonCache<ProcedureCallHandlerFactory>(ProcedureCallHandlerFactory.class);
    protected Connection connection = (Connection)this.getParameterValue("REPORT_CONNECTION");
    protected PreparedStatement statement;
    protected ResultSet resultSet;
    private boolean isCachedRowSet;
    private TimeZone parametersTimeZone;
    private boolean parametersTimeZoneOverride;
    private TimeZone fieldsTimeZone;
    private boolean fieldsTimeZoneOverride;
    private boolean isProcedureCall;
    private ProcedureCallHandler procedureCallHandler;

    public JRJdbcQueryExecuter(JasperReportsContext jasperReportsContext, JRDataset dataset, Map<String, ? extends JRValueParameter> parameters) {
        super(jasperReportsContext, dataset, parameters);
        if (this.connection == null) {
            if (log.isWarnEnabled()) {
                log.warn("The supplied java.sql.Connection object is null.");
            }
        } else if (log.isDebugEnabled()) {
            try {
                DatabaseMetaData metaData = this.connection.getMetaData();
                log.debug("DB is " + metaData.getDatabaseProductName() + " version " + metaData.getDatabaseProductVersion() + " (" + metaData.getDatabaseMajorVersion() + "/" + metaData.getDatabaseMinorVersion() + ")");
                log.debug("driver is " + metaData.getDriverName() + " version " + metaData.getDriverVersion() + " (" + metaData.getDriverMajorVersion() + "/" + metaData.getDriverMinorVersion() + ")");
                log.debug("jdbc " + metaData.getJDBCMajorVersion() + "/" + metaData.getJDBCMinorVersion());
                log.debug("connection URL is " + metaData.getURL());
            }
            catch (SQLException e) {
                log.debug("failed to read connection metadata", e);
            }
        }
        this.isCachedRowSet = this.getBooleanParameterOrProperty("net.sf.jasperreports.jdbc.cached.rowset", false);
        this.setTimeZone();
        this.registerFunctions();
        this.parseQuery();
    }

    protected void registerFunctions() {
    }

    @Override
    protected String getCanonicalQueryLanguage() {
        return CANONICAL_LANGUAGE;
    }

    protected void setTimeZone() {
        String timeZoneIdParam = (String)this.getParameterValue("net.sf.jasperreports.jdbc.time.zone", true);
        String timeZoneIdProp = this.getPropertiesUtil().getProperty(this.dataset, "net.sf.jasperreports.jdbc.time.zone");
        if (log.isDebugEnabled()) {
            log.debug("system timezone is " + TimeZone.getDefault());
            log.debug("report timezone is " + this.getParameterValue("REPORT_TIME_ZONE", true));
            log.debug("JDBC timezone parameter is " + timeZoneIdParam);
            log.debug("JDBC timezone property is " + timeZoneIdProp);
        }
        String parametersTimeZoneId = (String)this.getParameterValue("net.sf.jasperreports.jdbc.parameters.time.zone", true);
        if (log.isDebugEnabled()) {
            log.debug("JDBC parameters timezone parameter is " + parametersTimeZoneId);
        }
        String string = parametersTimeZoneId = parametersTimeZoneId == null ? timeZoneIdParam : parametersTimeZoneId;
        if (parametersTimeZoneId != null) {
            this.parametersTimeZoneOverride = true;
        } else {
            parametersTimeZoneId = this.getPropertiesUtil().getProperty(this.dataset, "net.sf.jasperreports.jdbc.parameters.time.zone");
            if (log.isDebugEnabled()) {
                log.debug("JDBC parameters timezone property is " + parametersTimeZoneId);
            }
            parametersTimeZoneId = parametersTimeZoneId == null ? timeZoneIdProp : parametersTimeZoneId;
        }
        this.parametersTimeZone = this.resolveTimeZone(parametersTimeZoneId);
        if (log.isDebugEnabled()) {
            log.debug("parameters timezone " + this.parametersTimeZone);
        }
        String fieldsTimeZoneId = (String)this.getParameterValue("net.sf.jasperreports.jdbc.fields.time.zone", true);
        if (log.isDebugEnabled()) {
            log.debug("JDBC fields timezone parameter is " + fieldsTimeZoneId);
        }
        String string2 = fieldsTimeZoneId = fieldsTimeZoneId == null ? timeZoneIdParam : fieldsTimeZoneId;
        if (fieldsTimeZoneId != null) {
            this.fieldsTimeZoneOverride = true;
        } else {
            fieldsTimeZoneId = this.getPropertiesUtil().getProperty(this.dataset, "net.sf.jasperreports.jdbc.fields.time.zone");
            if (log.isDebugEnabled()) {
                log.debug("JDBC fields timezone property is " + fieldsTimeZoneId);
            }
            fieldsTimeZoneId = fieldsTimeZoneId == null ? timeZoneIdProp : fieldsTimeZoneId;
        }
        this.fieldsTimeZone = this.resolveTimeZone(fieldsTimeZoneId);
        if (log.isDebugEnabled()) {
            log.debug("fields timezone " + this.fieldsTimeZone);
        }
    }

    protected TimeZone resolveTimeZone(String timezoneId) {
        TimeZone tz = timezoneId == null || timezoneId.length() == 0 ? null : (timezoneId.equals("REPORT_TIME_ZONE") ? (TimeZone)this.getParameterValue("REPORT_TIME_ZONE", true) : TimeZone.getTimeZone(timezoneId));
        return tz;
    }

    @Override
    protected String getParameterReplacement(String parameterName) {
        return "?";
    }

    @Override
    public JRDataSource createDatasource() throws JRException {
        JRResultSetDataSource dataSource = null;
        this.createStatement();
        if (this.statement != null) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Executing query");
                }
                ResultSet queryResult = this.isProcedureCall ? this.procedureCallHandler.execute() : this.statement.executeQuery();
                if (log.isDebugEnabled()) {
                    log.debug("Query execution done");
                }
                if (this.isCachedRowSet) {
                    CachedRowSet cachedRowSet;
                    try {
                        Class<?> clazz = Class.forName(CACHED_ROWSET_CLASS);
                        Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                        cachedRowSet = (CachedRowSet)constructor.newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        throw new JRException(e);
                    }
                    cachedRowSet.populate(queryResult);
                    this.closeStatement();
                    this.resultSet = cachedRowSet;
                } else {
                    this.resultSet = queryResult;
                }
                dataSource = new JRResultSetDataSource(this.getJasperReportsContext(), this.resultSet);
                dataSource.setTimeZone(this.fieldsTimeZone, this.fieldsTimeZoneOverride);
                TimeZone reportTimeZone = (TimeZone)this.getParameterValue("REPORT_TIME_ZONE", true);
                dataSource.setReportTimeZone(reportTimeZone);
            }
            catch (SQLTimeoutException e) {
                throw new JRException(EXCEPTION_MESSAGE_KEY_QUERY_STATEMENT_TIMEOUT_LIMIT_EXCEEDED, new Object[]{this.dataset.getName()}, e);
            }
            catch (SQLException e) {
                throw new JRException(EXCEPTION_MESSAGE_KEY_QUERY_STATEMENT_EXECUTE_ERROR, new Object[]{this.dataset.getName()}, e);
            }
        }
        return dataSource;
    }

    protected void createStatement() throws JRException {
        String queryString = this.getQueryString();
        if (log.isDebugEnabled()) {
            log.debug("SQL query string: " + queryString);
        }
        if (this.connection != null && queryString != null && queryString.trim().length() > 0) {
            try {
                Integer reportMaxCount;
                Integer queryTimeoutValue;
                int maxFieldSize;
                this.isProcedureCall = this.isProcedureCall(queryString);
                CallableStatement callableStatement = null;
                String type = this.getPropertiesUtil().getProperty(this.dataset, "net.sf.jasperreports.jdbc.result.set.type");
                String concurrency = this.getPropertiesUtil().getProperty(this.dataset, "net.sf.jasperreports.jdbc.concurrency");
                String holdability = this.getPropertiesUtil().getProperty(this.dataset, "net.sf.jasperreports.jdbc.holdability");
                if (type == null && concurrency == null && holdability == null) {
                    if (this.isProcedureCall) {
                        callableStatement = this.connection.prepareCall(queryString);
                        this.statement = callableStatement;
                    } else {
                        this.statement = this.connection.prepareStatement(queryString);
                    }
                } else {
                    type = type == null ? TYPE_FORWARD_ONLY : type;
                    String string = concurrency = concurrency == null ? CONCUR_READ_ONLY : concurrency;
                    if (holdability == null) {
                        if (this.isProcedureCall) {
                            callableStatement = this.connection.prepareCall(queryString, JRJdbcQueryExecuter.getResultSetType(type), JRJdbcQueryExecuter.getConcurrency(concurrency));
                            this.statement = callableStatement;
                        } else {
                            this.statement = this.connection.prepareStatement(queryString, JRJdbcQueryExecuter.getResultSetType(type), JRJdbcQueryExecuter.getConcurrency(concurrency));
                        }
                    } else if (this.isProcedureCall) {
                        callableStatement = this.connection.prepareCall(queryString, JRJdbcQueryExecuter.getResultSetType(type), JRJdbcQueryExecuter.getConcurrency(concurrency), JRJdbcQueryExecuter.getHoldability(holdability, this.connection));
                        this.statement = callableStatement;
                    } else {
                        this.statement = this.connection.prepareStatement(queryString, JRJdbcQueryExecuter.getResultSetType(type), JRJdbcQueryExecuter.getConcurrency(concurrency), JRJdbcQueryExecuter.getHoldability(holdability, this.connection));
                    }
                }
                int fetchSize = this.getPropertiesUtil().getIntegerProperty(this.dataset, "net.sf.jasperreports.jdbc.fetch.size", 0);
                if (fetchSize != 0) {
                    this.statement.setFetchSize(fetchSize);
                }
                if ((maxFieldSize = this.getPropertiesUtil().getIntegerProperty(this.dataset, "net.sf.jasperreports.jdbc.max.field.size", 0)) != 0) {
                    this.statement.setMaxFieldSize(maxFieldSize);
                }
                if ((queryTimeoutValue = this.getPropertiesUtil().getIntegerProperty(this.dataset, "net.sf.jasperreports.jdbc.query.timeout")) != null && queryTimeoutValue >= 0) {
                    this.statement.setQueryTimeout(queryTimeoutValue);
                }
                if ((reportMaxCount = (Integer)this.getParameterValue("REPORT_MAX_COUNT")) != null) {
                    this.statement.setMaxRows(reportMaxCount);
                }
                if (this.isProcedureCall) {
                    this.procedureCallHandler.init(callableStatement);
                }
                this.visitQueryParameters(new JRAbstractQueryExecuter.QueryParameterVisitor(){
                    int paramIdx = 1;

                    @Override
                    public void visit(JRAbstractQueryExecuter.QueryParameter queryParameter) {
                        try {
                            if (queryParameter.isMulti()) {
                                this.paramIdx += JRJdbcQueryExecuter.this.setStatementMultiParameters(this.paramIdx, queryParameter.getName(), queryParameter.isIgnoreNulls());
                            } else {
                                JRJdbcQueryExecuter.this.setStatementParameter(this.paramIdx, queryParameter.getName());
                                ++this.paramIdx;
                            }
                        }
                        catch (SQLException e) {
                            throw new JRAbstractQueryExecuter.VisitExceptionWrapper(e);
                        }
                    }

                    @Override
                    public void visit(JRAbstractQueryExecuter.ValuedQueryParameter valuedQueryParameter) {
                        Class<Object> type = valuedQueryParameter.getType();
                        Object value = valuedQueryParameter.getValue();
                        if (type == null) {
                            Class clazz = type = value == null ? Object.class : value.getClass();
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("Parameter #" + this.paramIdx + " (of type " + type.getName() + "): " + value);
                        }
                        try {
                            JRJdbcQueryExecuter.this.setStatementParameter(this.paramIdx, type, value, JRJdbcQueryExecuter.this.dataset);
                            ++this.paramIdx;
                        }
                        catch (SQLException e) {
                            throw new JRAbstractQueryExecuter.VisitExceptionWrapper(e);
                        }
                    }
                });
            }
            catch (JRAbstractQueryExecuter.VisitExceptionWrapper e) {
                throw new JRException(EXCEPTION_MESSAGE_KEY_QUERY_STATEMENT_PREPARE_ERROR, new Object[]{queryString}, e.getCause());
            }
            catch (SQLException e) {
                throw new JRException(EXCEPTION_MESSAGE_KEY_QUERY_STATEMENT_PREPARE_ERROR, new Object[]{queryString}, e);
            }
        }
    }

    protected boolean isProcedureCall(String queryString) throws SQLException {
        String factoryClass = JRPropertiesUtil.getInstance(this.getJasperReportsContext()).getProperty(this.dataset, "net.sf.jasperreports.jdbc.procedure.call.handler.factory");
        if (factoryClass != null && factoryClass.trim().length() > 0) {
            try {
                ProcedureCallHandlerFactory factory = procedureCallHandlerFactoryCache.getCachedInstance(factoryClass);
                this.procedureCallHandler = factory.createProcedureCallHandler();
            }
            catch (JRException e) {
                throw new JRRuntimeException(e);
            }
        }
        return this.procedureCallHandler == null ? false : this.procedureCallHandler.isHandling(this.connection, queryString);
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    protected void setStatementParameter(int parameterIndex, String parameterName) throws SQLException {
        JRValueParameter parameter = this.getValueParameter(parameterName);
        Class<?> clazz = parameter.getValueClass();
        Object parameterValue = parameter.getValue();
        if (log.isDebugEnabled()) {
            log.debug("Parameter #" + parameterIndex + " (" + parameterName + " of type " + clazz.getName() + "): " + parameterValue);
        }
        this.setStatementParameter(parameterIndex, clazz, parameterValue, parameter);
    }

    protected int setStatementMultiParameters(int parameterIndex, String parameterName, boolean ignoreNulls) throws SQLException {
        JRValueParameter parameter = this.getValueParameter(parameterName);
        Object paramValue = parameter.getValue();
        int index = 0;
        if (paramValue.getClass().isArray()) {
            int arrayCount = Array.getLength(paramValue);
            for (int count = 0; count < arrayCount; ++count) {
                Object value = Array.get(paramValue, count);
                if (ignoreNulls && value == null) continue;
                this.setStatementMultiParameter(parameterIndex + index, parameterName, count, value, parameter);
                ++index;
            }
        } else if (paramValue instanceof Collection) {
            Collection values = (Collection)paramValue;
            int count = 0;
            for (Object value : values) {
                if (!ignoreNulls || value != null) {
                    this.setStatementMultiParameter(parameterIndex + index, parameterName, count, value, parameter);
                    ++index;
                }
                ++count;
            }
        } else {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_UNEXPECTED_MULTI_PARAMETER_TYPE, (Object[])null);
        }
        return index;
    }

    protected void setStatementMultiParameter(int parameterIndex, String parameterName, int valueIndex, Object value, JRPropertiesHolder properties) throws SQLException {
        if (value == null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_MULTI_PARAMETERS_CANNOT_CONTAIN_NULL_VALUES, (Object[])null);
        }
        Class<?> type = value.getClass();
        if (log.isDebugEnabled()) {
            log.debug("Parameter #" + parameterIndex + " (" + parameterName + "[" + valueIndex + "] of type " + type.getName() + "): " + value);
        }
        this.setStatementParameter(parameterIndex, type, value, properties);
    }

    protected void setStatementParameter(int parameterIndex, Class<?> parameterType, Object parameterValue, JRPropertiesHolder properties) throws SQLException {
        if (Boolean.class.isAssignableFrom(parameterType)) {
            if (parameterValue == null) {
                this.statement.setNull(parameterIndex, -7);
            } else {
                this.statement.setBoolean(parameterIndex, (Boolean)parameterValue);
            }
        } else if (Byte.class.isAssignableFrom(parameterType)) {
            if (parameterValue == null) {
                this.statement.setNull(parameterIndex, -6);
            } else {
                this.statement.setByte(parameterIndex, (Byte)parameterValue);
            }
        } else if (Double.class.isAssignableFrom(parameterType)) {
            if (parameterValue == null) {
                this.statement.setNull(parameterIndex, 8);
            } else {
                this.statement.setDouble(parameterIndex, (Double)parameterValue);
            }
        } else if (Float.class.isAssignableFrom(parameterType)) {
            if (parameterValue == null) {
                this.statement.setNull(parameterIndex, 6);
            } else {
                this.statement.setFloat(parameterIndex, ((Float)parameterValue).floatValue());
            }
        } else if (Integer.class.isAssignableFrom(parameterType)) {
            if (parameterValue == null) {
                this.statement.setNull(parameterIndex, 4);
            } else {
                this.statement.setInt(parameterIndex, (Integer)parameterValue);
            }
        } else if (Long.class.isAssignableFrom(parameterType)) {
            if (parameterValue == null) {
                this.statement.setNull(parameterIndex, -5);
            } else {
                this.statement.setLong(parameterIndex, (Long)parameterValue);
            }
        } else if (Short.class.isAssignableFrom(parameterType)) {
            if (parameterValue == null) {
                this.statement.setNull(parameterIndex, 5);
            } else {
                this.statement.setShort(parameterIndex, (Short)parameterValue);
            }
        } else if (BigDecimal.class.isAssignableFrom(parameterType)) {
            if (parameterValue == null) {
                this.statement.setNull(parameterIndex, 3);
            } else {
                this.statement.setBigDecimal(parameterIndex, (BigDecimal)parameterValue);
            }
        } else if (String.class.isAssignableFrom(parameterType)) {
            if (parameterValue == null) {
                this.statement.setNull(parameterIndex, 12);
            } else {
                this.statement.setString(parameterIndex, parameterValue.toString());
            }
        } else if (Timestamp.class.isAssignableFrom(parameterType)) {
            this.setTimestamp(parameterIndex, parameterValue, properties);
        } else if (Time.class.isAssignableFrom(parameterType)) {
            this.setTime(parameterIndex, parameterValue, properties);
        } else if (java.util.Date.class.isAssignableFrom(parameterType)) {
            this.setDate(parameterIndex, parameterValue, properties);
        } else {
            boolean handled;
            if (this.isProcedureCall && (handled = this.procedureCallHandler.setParameterValue(parameterIndex, parameterType, parameterValue))) {
                return;
            }
            if (parameterValue == null) {
                this.statement.setNull(parameterIndex, 2000);
            } else {
                this.statement.setObject(parameterIndex, parameterValue);
            }
        }
    }

    protected void setTimestamp(int parameterIndex, Object parameterValue, JRPropertiesHolder properties) throws SQLException {
        if (parameterValue == null) {
            this.statement.setNull(parameterIndex, 93);
        } else {
            Calendar cal = this.getParameterCalendar(properties);
            if (log.isDebugEnabled()) {
                log.debug("setting timestamp parameter " + parameterIndex + " as " + parameterValue + " (" + ((Timestamp)parameterValue).getTime() + ") with calendar " + cal);
            }
            if (cal == null) {
                this.statement.setTimestamp(parameterIndex, (Timestamp)parameterValue);
            } else {
                this.statement.setTimestamp(parameterIndex, (Timestamp)parameterValue, cal);
            }
        }
    }

    protected void setTime(int parameterIndex, Object parameterValue, JRPropertiesHolder properties) throws SQLException {
        if (parameterValue == null) {
            this.statement.setNull(parameterIndex, 92);
        } else {
            Calendar cal = this.getParameterCalendar(properties);
            if (log.isDebugEnabled()) {
                log.debug("setting time parameter " + parameterIndex + " as " + parameterValue + " (" + ((Time)parameterValue).getTime() + ") with calendar " + cal);
            }
            if (cal == null) {
                this.statement.setTime(parameterIndex, (Time)parameterValue);
            } else {
                this.statement.setTime(parameterIndex, (Time)parameterValue, cal);
            }
        }
    }

    protected void setDate(int parameterIndex, Object parameterValue, JRPropertiesHolder properties) throws SQLException {
        if (parameterValue == null) {
            this.statement.setNull(parameterIndex, 91);
        } else {
            Calendar cal = this.getParameterCalendar(properties);
            if (log.isDebugEnabled()) {
                log.debug("setting date parameter " + parameterIndex + " as " + parameterValue + " (" + ((java.util.Date)parameterValue).getTime() + ") with calendar " + cal);
            }
            if (cal == null) {
                this.statement.setDate(parameterIndex, new Date(((java.util.Date)parameterValue).getTime()));
            } else {
                this.statement.setDate(parameterIndex, new Date(((java.util.Date)parameterValue).getTime()), cal);
            }
        }
    }

    protected Calendar getParameterCalendar(JRPropertiesHolder properties) {
        TimeZone tz;
        if (this.parametersTimeZoneOverride) {
            tz = this.parametersTimeZone;
        } else if (properties.hasProperties() && properties.getPropertiesMap().containsProperty("net.sf.jasperreports.jdbc.time.zone")) {
            String timezoneId = this.getPropertiesUtil().getProperty(properties, "net.sf.jasperreports.jdbc.time.zone");
            if (log.isDebugEnabled()) {
                log.debug("parameter timezone property " + timezoneId);
            }
            tz = this.resolveTimeZone(timezoneId);
        } else {
            tz = this.parametersTimeZone;
        }
        Calendar cal = tz == null ? null : Calendar.getInstance(tz);
        return cal;
    }

    @Override
    public synchronized void close() {
        if (this.resultSet != null) {
            try {
                this.resultSet.close();
            }
            catch (SQLException e) {
                log.error("Error while closing result set.", e);
            }
            finally {
                this.resultSet = null;
            }
        }
        if (this.statement != null) {
            this.closeStatement();
        }
    }

    protected void closeStatement() {
        try {
            this.statement.close();
        }
        catch (SQLException e) {
            log.error("Error while closing statement.", e);
        }
        finally {
            this.statement = null;
        }
    }

    @Override
    public synchronized boolean cancelQuery() throws JRException {
        if (this.statement != null) {
            try {
                this.statement.cancel();
                return true;
            }
            catch (Exception e) {
                throw new JRException(EXCEPTION_MESSAGE_KEY_QUERY_STATEMENT_CANCEL_ERROR, null, e);
            }
        }
        return false;
    }

    protected static int getResultSetType(String type) {
        if (TYPE_FORWARD_ONLY.equals(type)) {
            return 1003;
        }
        if (TYPE_SCROLL_INSENSITIVE.equals(type)) {
            return 1004;
        }
        if (TYPE_SCROLL_SENSITIVE.equals(type)) {
            return 1005;
        }
        return 1003;
    }

    protected static int getConcurrency(String concurrency) {
        if (CONCUR_READ_ONLY.equals(concurrency)) {
            return 1007;
        }
        if (CONCUR_UPDATABLE.equals(concurrency)) {
            return 1008;
        }
        return 1007;
    }

    protected static int getHoldability(String holdability, Connection connection) throws SQLException {
        if (HOLD_CURSORS_OVER_COMMIT.equals(holdability)) {
            return 1;
        }
        if (CLOSE_CURSORS_AT_COMMIT.equals(holdability)) {
            return 2;
        }
        return connection.getHoldability();
    }
}

