/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.font.FontRenderContext;
import java.text.AttributedCharacterIterator;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.JRCommonText;
import net.sf.jasperreports.engine.JRParagraph;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.TabStop;
import net.sf.jasperreports.engine.export.AbstractTextRenderer;
import net.sf.jasperreports.engine.export.AwtTextRenderer;
import net.sf.jasperreports.engine.fill.ComplexTextLineWrapper;
import net.sf.jasperreports.engine.fill.DynamicPropertiesHolder;
import net.sf.jasperreports.engine.fill.JRMeasuredText;
import net.sf.jasperreports.engine.fill.JRTextMeasurer;
import net.sf.jasperreports.engine.fill.SimpleTextLineWrapper;
import net.sf.jasperreports.engine.fill.TabSegment;
import net.sf.jasperreports.engine.fill.TextLine;
import net.sf.jasperreports.engine.fill.TextLineWrapper;
import net.sf.jasperreports.engine.fill.TextMeasureContext;
import net.sf.jasperreports.engine.fonts.FontUtil;
import net.sf.jasperreports.engine.util.DelegatePropertiesHolder;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRTextAttribute;
import net.sf.jasperreports.engine.util.ParagraphUtil;
import net.sf.jasperreports.engine.util.StyledTextWriteContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TextMeasurer
implements JRTextMeasurer {
    private static final Log log = LogFactory.getLog(TextMeasurer.class);
    public static final String PROPERTY_MEASURE_SIMPLE_TEXTS = "net.sf.jasperreports.measure.simple.text";
    private FontUtil fontUtil;
    protected JasperReportsContext jasperReportsContext;
    protected JRCommonText textElement;
    private JRPropertiesHolder propertiesHolder;
    private DynamicPropertiesHolder dynamicPropertiesHolder;
    private SimpleTextLineWrapper simpleLineWrapper;
    private ComplexTextLineWrapper complexLineWrapper;
    protected int width;
    private int height;
    private int topPadding;
    protected int leftPadding;
    private int bottomPadding;
    protected int rightPadding;
    private JRParagraph jrParagraph;
    private boolean isFirstParagraph;
    private float formatWidth;
    protected int maxHeight;
    private boolean indentFirstLine;
    private boolean canOverflow;
    private boolean hasDynamicIgnoreMissingFontProp;
    private boolean defaultIgnoreMissingFont;
    private boolean ignoreMissingFont;
    private boolean hasDynamicSaveLineBreakOffsetsProp;
    private boolean defaultSaveLineBreakOffsets;
    protected TextMeasuredState measuredState;
    protected TextMeasuredState prevMeasuredState;
    protected int htmlListIndent;

    public TextMeasurer(JasperReportsContext jasperReportsContext, JRCommonText textElement) {
        this(FontUtil.getInstance(jasperReportsContext), textElement);
    }

    public TextMeasurer(FontUtil fontUtil, JRCommonText textElement) {
        this.fontUtil = fontUtil;
        this.jasperReportsContext = fontUtil.getJasperReportsContext();
        this.textElement = textElement;
        JRPropertiesHolder jRPropertiesHolder = this.propertiesHolder = textElement instanceof JRPropertiesHolder ? (JRPropertiesHolder)((Object)textElement) : null;
        if (textElement.getDefaultStyleProvider() instanceof JRPropertiesHolder) {
            this.propertiesHolder = new DelegatePropertiesHolder(this.propertiesHolder, (JRPropertiesHolder)((Object)textElement.getDefaultStyleProvider()));
        }
        if (textElement instanceof DynamicPropertiesHolder) {
            this.dynamicPropertiesHolder = (DynamicPropertiesHolder)((Object)textElement);
            this.hasDynamicIgnoreMissingFontProp = this.dynamicPropertiesHolder.hasDynamicProperty("net.sf.jasperreports.awt.ignore.missing.font");
            this.hasDynamicSaveLineBreakOffsetsProp = this.dynamicPropertiesHolder.hasDynamicProperty("net.sf.jasperreports.text.save.line.breaks");
        }
        JRPropertiesUtil propertiesUtil = JRPropertiesUtil.getInstance(this.jasperReportsContext);
        this.defaultIgnoreMissingFont = propertiesUtil.getBooleanProperty(this.propertiesHolder, "net.sf.jasperreports.awt.ignore.missing.font", false);
        this.defaultSaveLineBreakOffsets = propertiesUtil.getBooleanProperty(this.propertiesHolder, "net.sf.jasperreports.text.save.line.breaks", false);
        Context measureContext = new Context();
        this.simpleLineWrapper = new SimpleTextLineWrapper();
        this.simpleLineWrapper.init(measureContext);
        this.complexLineWrapper = new ComplexTextLineWrapper();
        this.complexLineWrapper.init(measureContext);
    }

    protected void initialize(JRStyledText styledText, int remainingTextStart, int availableStretchHeight, boolean indentFirstLine, boolean canOverflow) {
        String dynamicSaveLineBreakOffsetsProp;
        String dynamicIgnoreMissingFontProp;
        this.width = this.textElement.getWidth();
        this.height = this.textElement.getHeight();
        this.topPadding = this.textElement.getLineBox().getTopPadding();
        this.leftPadding = this.textElement.getLineBox().getLeftPadding();
        this.bottomPadding = this.textElement.getLineBox().getBottomPadding();
        this.rightPadding = this.textElement.getLineBox().getRightPadding();
        this.jrParagraph = this.textElement.getParagraph();
        switch (this.textElement.getRotation()) {
            case LEFT: {
                this.width = this.textElement.getHeight();
                this.height = this.textElement.getWidth();
                int tmpPadding = this.topPadding;
                this.topPadding = this.leftPadding;
                this.leftPadding = this.bottomPadding;
                this.bottomPadding = this.rightPadding;
                this.rightPadding = tmpPadding;
                break;
            }
            case RIGHT: {
                this.width = this.textElement.getHeight();
                this.height = this.textElement.getWidth();
                int tmpPadding = this.topPadding;
                this.topPadding = this.rightPadding;
                this.rightPadding = this.bottomPadding;
                this.bottomPadding = this.leftPadding;
                this.leftPadding = tmpPadding;
                break;
            }
            case UPSIDE_DOWN: {
                int tmpPadding = this.topPadding;
                this.topPadding = this.bottomPadding;
                this.bottomPadding = tmpPadding;
                tmpPadding = this.leftPadding;
                this.leftPadding = this.rightPadding;
                this.rightPadding = tmpPadding;
                break;
            }
        }
        this.formatWidth = this.width - this.leftPadding - this.rightPadding;
        this.formatWidth = this.formatWidth < 0.0f ? 0.0f : this.formatWidth;
        this.maxHeight = this.height + availableStretchHeight - this.topPadding - this.bottomPadding;
        this.maxHeight = this.maxHeight < 0 ? 0 : this.maxHeight;
        this.indentFirstLine = indentFirstLine;
        this.canOverflow = canOverflow;
        this.ignoreMissingFont = this.defaultIgnoreMissingFont;
        if (this.hasDynamicIgnoreMissingFontProp && (dynamicIgnoreMissingFontProp = this.dynamicPropertiesHolder.getDynamicProperties().getProperty("net.sf.jasperreports.awt.ignore.missing.font")) != null) {
            this.ignoreMissingFont = JRPropertiesUtil.asBoolean(dynamicIgnoreMissingFontProp);
        }
        boolean saveLineBreakOffsets = this.defaultSaveLineBreakOffsets;
        if (this.hasDynamicSaveLineBreakOffsetsProp && (dynamicSaveLineBreakOffsetsProp = this.dynamicPropertiesHolder.getDynamicProperties().getProperty("net.sf.jasperreports.text.save.line.breaks")) != null) {
            saveLineBreakOffsets = JRPropertiesUtil.asBoolean(dynamicSaveLineBreakOffsetsProp);
        }
        this.measuredState = new TextMeasuredState(saveLineBreakOffsets);
        this.measuredState.lastOffset = remainingTextStart;
        this.prevMeasuredState = null;
    }

    @Override
    public JRMeasuredText measure(JRStyledText styledText, int remainingTextStart, int availableStretchHeight, boolean indentFirstLine, boolean canOverflow) {
        this.initialize(styledText, remainingTextStart, availableStretchHeight, indentFirstLine, canOverflow);
        TextLineWrapper lineWrapper = this.simpleLineWrapper;
        if (!lineWrapper.start(styledText)) {
            lineWrapper = this.complexLineWrapper;
            lineWrapper.start(styledText);
        }
        StyledTextWriteContext context = new StyledTextWriteContext(true);
        AttributedCharacterIterator allParagraphs = styledText.getAwtAttributedString(this.fontUtil, this.ignoreMissingFont).getIterator();
        this.isFirstParagraph = true;
        boolean verticalSpaceRemaining = true;
        int runLimit = 0;
        int runStart = remainingTextStart;
        allParagraphs.setIndex(runStart);
        while (verticalSpaceRemaining && runStart < allParagraphs.getEndIndex() && (runLimit = allParagraphs.getRunLimit(JRTextAttribute.HTML_LIST_ATTRIBUTES)) <= allParagraphs.getEndIndex()) {
            Map<AttributedCharacterIterator.Attribute, Object> attributes = allParagraphs.getAttributes();
            context.next(attributes);
            this.prepareBullet(context);
            int paragraphStart = 0;
            boolean lastTokenWasNewline = false;
            String runText = styledText.getText().substring(runStart, runLimit);
            StringTokenizer tkzer = new StringTokenizer(runText, "\n", true);
            while (tkzer.hasMoreTokens() && verticalSpaceRemaining) {
                String paragraphText = tkzer.nextToken();
                if ("\n".equals(paragraphText)) {
                    if (lastTokenWasNewline) {
                        verticalSpaceRemaining = this.renderParagraph(lineWrapper, runStart + paragraphStart - 1, null);
                    }
                    if (paragraphStart == 0 || runStart + paragraphStart == allParagraphs.getEndIndex() - 1) {
                        verticalSpaceRemaining = this.renderParagraph(lineWrapper, runStart + paragraphStart, null);
                    }
                    lastTokenWasNewline = true;
                } else {
                    verticalSpaceRemaining = this.renderParagraph(lineWrapper, runStart + paragraphStart, paragraphText);
                    lastTokenWasNewline = false;
                }
                paragraphStart += paragraphText.length();
                this.isFirstParagraph = false;
            }
            runStart = runLimit;
            allParagraphs.setIndex(runStart);
        }
        return this.measuredState;
    }

    protected boolean hasParagraphIndents() {
        Integer firstLineIndent = this.jrParagraph.getFirstLineIndent();
        if (firstLineIndent != null && firstLineIndent > 0) {
            return true;
        }
        Integer leftIndent = this.jrParagraph.getLeftIndent();
        if (leftIndent != null && leftIndent > 0) {
            return true;
        }
        Integer rightIndent = this.jrParagraph.getRightIndent();
        return rightIndent != null && rightIndent > 0;
    }

    protected boolean renderParagraph(TextLineWrapper lineWrapper, int paragraphStart, String paragraphText) {
        if (paragraphText == null) {
            lineWrapper.startEmptyParagraph(paragraphStart);
        } else {
            lineWrapper.startParagraph(paragraphStart, paragraphStart + paragraphText.length(), false);
        }
        List<Integer> tabIndexes = JRStringUtil.getTabIndexes(paragraphText);
        int[] currentTabHolder = new int[]{0};
        TabStop[] nextTabStopHolder = new TabStop[]{null};
        boolean[] requireNextWordHolder = new boolean[]{false};
        this.measuredState.textOffset = paragraphStart;
        boolean rendered = true;
        boolean renderedLine = false;
        while (lineWrapper.paragraphPosition() < lineWrapper.paragraphEnd() && rendered) {
            rendered = this.renderNextLine(lineWrapper, tabIndexes, currentTabHolder, nextTabStopHolder, requireNextWordHolder);
            renderedLine = renderedLine || rendered;
        }
        if (!rendered && this.prevMeasuredState != null && !this.canOverflow) {
            this.processLastTruncatedRow(lineWrapper, paragraphText, paragraphStart, renderedLine);
        }
        return rendered;
    }

    private void prepareBullet(StyledTextWriteContext context) {
        this.htmlListIndent = context.getDepth() * 50;
    }

    protected void processLastTruncatedRow(TextLineWrapper lineWrapper, String paragraphText, int paragraphOffset, boolean lineTruncated) {
        if (lineTruncated && this.isToTruncateAtChar()) {
            this.truncateLastLineAtChar(lineWrapper, paragraphText, paragraphOffset);
        }
        this.appendTruncateSuffix(lineWrapper);
    }

    protected void truncateLastLineAtChar(TextLineWrapper lineWrapper, String paragraphText, int paragraphOffset) {
        this.measuredState = this.prevMeasuredState.cloneState();
        lineWrapper.startParagraph(this.measuredState.textOffset, paragraphOffset + paragraphText.length(), true);
        this.renderNextLine(lineWrapper, null, new int[]{0}, new TabStop[]{null}, new boolean[]{false});
    }

    protected void appendTruncateSuffix(TextLineWrapper lineWrapper) {
        String truncateSuffx = this.getTruncateSuffix();
        if (truncateSuffx == null) {
            return;
        }
        int lineStart = this.prevMeasuredState.textOffset;
        String lineText = lineWrapper.getLineText(lineStart, this.measuredState.textOffset);
        int linePosition = lineText.length();
        boolean done = false;
        do {
            this.measuredState = this.prevMeasuredState.cloneState();
            String text = lineText.substring(0, linePosition) + truncateSuffx;
            boolean truncateAtChar = this.isToTruncateAtChar();
            TextLineWrapper lastLineWrapper = lineWrapper.lastLineWrapper(text, this.measuredState.textOffset, linePosition, truncateAtChar);
            BreakIterator breakIterator = truncateAtChar ? BreakIterator.getCharacterInstance() : BreakIterator.getLineInstance();
            breakIterator.setText(text);
            if (this.renderNextLine(lastLineWrapper, null, new int[]{0}, new TabStop[]{null}, new boolean[]{false})) {
                int lastPos = lastLineWrapper.paragraphPosition();
                if (lastPos == linePosition + truncateSuffx.length()) {
                    this.measuredState.textOffset -= truncateSuffx.length();
                    this.measuredState.textSuffix = truncateSuffx;
                    done = true;
                    continue;
                }
                if ((linePosition = breakIterator.preceding(linePosition)) != -1) continue;
                String actualSuffix = truncateSuffx.substring(0, this.measuredState.textOffset - this.prevMeasuredState.textOffset);
                if (this.prevMeasuredState.textOffset > 0 && lineWrapper.charAt(this.prevMeasuredState.textOffset - 1) != '\n') {
                    actualSuffix = '\n' + actualSuffix;
                }
                this.measuredState.textSuffix = actualSuffix;
                this.measuredState.textOffset = this.prevMeasuredState.textOffset;
                done = true;
                continue;
            }
            done = true;
        } while (!done);
    }

    protected boolean isToTruncateAtChar() {
        return JRPropertiesUtil.getInstance(this.jasperReportsContext).getBooleanProperty(this.propertiesHolder, "net.sf.jasperreports.text.truncate.at.char", false);
    }

    protected String getTruncateSuffix() {
        String truncateSuffx = JRPropertiesUtil.getInstance(this.jasperReportsContext).getProperty(this.propertiesHolder, "net.sf.jasperreports.text.truncate.suffix");
        if (truncateSuffx != null && (truncateSuffx = truncateSuffx.trim()).length() == 0) {
            truncateSuffx = null;
        }
        return truncateSuffx;
    }

    protected boolean renderNextLine(TextLineWrapper lineWrapper, List<Integer> tabIndexes, int[] currentTabHolder, TabStop[] nextTabStopHolder, boolean[] requireNextWordHolder) {
        float newTextHeight;
        boolean fits;
        boolean lineComplete = false;
        int lineStartPosition = lineWrapper.paragraphPosition();
        float maxAscent = 0.0f;
        float maxDescent = 0.0f;
        float maxLeading = 0.0f;
        int characterCount = 0;
        boolean isLeftToRight = true;
        ArrayList<TabSegment> segments = new ArrayList<TabSegment>(1);
        TabSegment oldSegment = null;
        TabSegment crtSegment = null;
        while (!lineComplete) {
            int firstLineIndent;
            int tabIndexOrEndIndex = tabIndexes == null || currentTabHolder[0] >= tabIndexes.size() ? lineWrapper.paragraphEnd() : tabIndexes.get(currentTabHolder[0]) + 1;
            int n = firstLineIndent = lineWrapper.paragraphPosition() == 0 ? this.jrParagraph.getFirstLineIndent() : 0;
            if (firstLineIndent != 0 && this.isFirstParagraph && !this.indentFirstLine) {
                firstLineIndent = 0;
            }
            float startX = this.htmlListIndent + firstLineIndent + this.leftPadding;
            float endX = this.width - this.jrParagraph.getRightIndent() - this.rightPadding;
            endX = endX < startX ? startX : endX;
            int startIndex = lineWrapper.paragraphPosition();
            float rightX = 0.0f;
            if (segments.size() == 0) {
                rightX = startX;
            } else {
                rightX = oldSegment.rightX;
                nextTabStopHolder[0] = ParagraphUtil.getNextTabStop(this.jrParagraph, endX, rightX);
            }
            float availableWidth = endX - (float)this.jrParagraph.getLeftIndent().intValue() - ParagraphUtil.getSegmentOffset(nextTabStopHolder[0], rightX);
            TextLine textLine = lineWrapper.nextLine(availableWidth, tabIndexOrEndIndex, requireNextWordHolder[0]);
            if (textLine != null) {
                maxAscent = Math.max(maxAscent, textLine.getAscent());
                maxDescent = Math.max(maxDescent, textLine.getDescent());
                maxLeading = Math.max(maxLeading, textLine.getLeading());
                characterCount += textLine.getCharacterCount();
                isLeftToRight = isLeftToRight && textLine.isLeftToRight();
                crtSegment = new TabSegment();
                crtSegment.textLine = textLine;
                float leftX = ParagraphUtil.getLeftX(nextTabStopHolder[0], textLine.getAdvance());
                if (rightX > leftX) {
                    crtSegment.leftX = rightX;
                    crtSegment.rightX = rightX + textLine.getAdvance();
                } else {
                    crtSegment.leftX = leftX;
                    crtSegment.rightX = ParagraphUtil.getRightX(nextTabStopHolder[0], textLine.getAdvance());
                }
                segments.add(crtSegment);
            }
            requireNextWordHolder[0] = true;
            if (lineWrapper.paragraphPosition() == tabIndexOrEndIndex) {
                currentTabHolder[0] = currentTabHolder[0] + 1;
            }
            if (lineWrapper.paragraphPosition() == lineWrapper.paragraphEnd()) {
                lineComplete = true;
                nextTabStopHolder[0] = null;
            } else if (lineWrapper.paragraphPosition() == tabIndexOrEndIndex) {
                if (crtSegment.rightX >= (float)ParagraphUtil.getLastTabStop(this.jrParagraph, endX).getPosition()) {
                    lineComplete = true;
                    nextTabStopHolder[0] = ParagraphUtil.getFirstTabStop(this.jrParagraph, endX);
                }
            } else {
                lineComplete = true;
                if (textLine == null) {
                    if (nextTabStopHolder[0].getPosition() == ParagraphUtil.getFirstTabStop(this.jrParagraph, endX).getPosition()) {
                        nextTabStopHolder[0] = null;
                        requireNextWordHolder[0] = false;
                        TextLine baseLine = lineWrapper.baseTextLine(startIndex);
                        maxAscent = baseLine.getAscent();
                        maxDescent = baseLine.getDescent();
                        maxLeading = baseLine.getLeading();
                    } else {
                        nextTabStopHolder[0] = ParagraphUtil.getFirstTabStop(this.jrParagraph, endX);
                    }
                } else {
                    nextTabStopHolder[0] = null;
                    requireNextWordHolder[0] = false;
                }
            }
            oldSegment = crtSegment;
        }
        float lineHeight = AbstractTextRenderer.getLineHeight(this.measuredState.lines == 0, this.jrParagraph, maxLeading, maxAscent);
        if (this.measuredState.lines == 0) {
            lineHeight += (float)this.jrParagraph.getSpacingBefore().intValue();
        }
        boolean bl = fits = (newTextHeight = this.measuredState.textHeight + lineHeight) + maxDescent <= (float)this.maxHeight;
        if (fits) {
            float crtTextWidth;
            this.prevMeasuredState = this.measuredState.cloneState();
            this.measuredState.isLeftToRight = isLeftToRight;
            this.measuredState.spacingBefore = this.jrParagraph.getSpacingBefore();
            int crtCharCount = lineWrapper.paragraphPosition() - lineStartPosition;
            float f = crtTextWidth = crtSegment == null ? 0.0f : crtSegment.rightX - (float)this.leftPadding;
            if (crtTextWidth > this.measuredState.textWidth) {
                this.measuredState.textWidth = crtTextWidth;
                this.measuredState.averageCharWidth = crtTextWidth / (float)crtCharCount;
            }
            this.measuredState.textHeight = newTextHeight;
            ++this.measuredState.lines;
            if (this.measuredState.isMeasured && (tabIndexes == null || tabIndexes.size() == 0) && !this.hasParagraphIndents()) {
                this.measuredState.fontSizeSum += lineWrapper.maxFontsize(lineStartPosition, lineStartPosition + characterCount);
                if (this.measuredState.lines == 1) {
                    this.measuredState.firstLineLeading = this.measuredState.textHeight;
                    this.measuredState.firstLineMaxFontSize = this.measuredState.fontSizeSum;
                }
            } else {
                this.measuredState.isMeasured = false;
            }
            this.measuredState.textHeight += maxDescent;
            this.measuredState.textOffset += crtCharCount;
            if (lineWrapper.paragraphPosition() < lineWrapper.paragraphEnd()) {
                this.measuredState.addLineBreak();
            }
            this.measuredState.isParagraphCut = lineWrapper.paragraphPosition() < lineWrapper.paragraphEnd();
        }
        return fits;
    }

    protected JRPropertiesHolder getTextPropertiesHolder() {
        return this.propertiesHolder;
    }

    public FontRenderContext getFontRenderContext() {
        return AwtTextRenderer.LINE_BREAK_FONT_RENDER_CONTEXT;
    }

    class Context
    implements TextMeasureContext {
        Context() {
        }

        @Override
        public JasperReportsContext getJasperReportsContext() {
            return TextMeasurer.this.jasperReportsContext;
        }

        @Override
        public FontUtil getFontUtil() {
            return TextMeasurer.this.fontUtil;
        }

        @Override
        public JRCommonText getElement() {
            return TextMeasurer.this.textElement;
        }

        @Override
        public JRPropertiesHolder getPropertiesHolder() {
            return TextMeasurer.this.propertiesHolder;
        }

        @Override
        public boolean isIgnoreMissingFont() {
            return TextMeasurer.this.ignoreMissingFont;
        }

        @Override
        public FontRenderContext getFontRenderContext() {
            return TextMeasurer.this.getFontRenderContext();
        }
    }

    protected static class TextMeasuredState
    implements JRMeasuredText,
    Cloneable {
        private final boolean saveLineBreakOffsets;
        protected int textOffset;
        protected int lines;
        protected float fontSizeSum;
        protected float firstLineMaxFontSize;
        protected int spacingBefore;
        protected float textWidth;
        protected float textHeight;
        protected float averageCharWidth;
        protected float firstLineLeading;
        protected boolean isLeftToRight = true;
        protected boolean isParagraphCut;
        protected String textSuffix;
        protected boolean isMeasured = true;
        protected int lastOffset;
        protected ArrayList<Integer> lineBreakOffsets;

        public TextMeasuredState(boolean saveLineBreakOffsets) {
            this.saveLineBreakOffsets = saveLineBreakOffsets;
        }

        @Override
        public boolean isLeftToRight() {
            return this.isLeftToRight;
        }

        @Override
        public int getTextOffset() {
            return this.textOffset;
        }

        @Override
        public float getTextWidth() {
            return this.textWidth;
        }

        @Override
        public float getAverageCharWidth() {
            return this.averageCharWidth;
        }

        @Override
        public float getTextHeight() {
            return this.textHeight;
        }

        @Override
        public float getLineSpacingFactor() {
            if (this.isMeasured && this.lines > 0 && this.fontSizeSum > 0.0f) {
                return (this.textHeight - (float)this.spacingBefore) / this.fontSizeSum;
            }
            return 0.0f;
        }

        @Override
        public float getLeadingOffset() {
            if (this.isMeasured && this.lines > 0 && this.fontSizeSum > 0.0f) {
                return this.firstLineLeading - this.firstLineMaxFontSize * this.getLineSpacingFactor();
            }
            return 0.0f;
        }

        @Override
        public boolean isParagraphCut() {
            return this.isParagraphCut;
        }

        @Override
        public String getTextSuffix() {
            return this.textSuffix;
        }

        public TextMeasuredState cloneState() {
            try {
                TextMeasuredState clone = (TextMeasuredState)super.clone();
                if (this.lineBreakOffsets != null) {
                    clone.lineBreakOffsets = (ArrayList)this.lineBreakOffsets.clone();
                }
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new JRRuntimeException(e);
            }
        }

        protected void addLineBreak() {
            if (this.saveLineBreakOffsets) {
                if (this.lineBreakOffsets == null) {
                    this.lineBreakOffsets = new ArrayList();
                }
                int breakOffset = this.textOffset - this.lastOffset;
                this.lineBreakOffsets.add(breakOffset);
                this.lastOffset = this.textOffset;
            }
        }

        @Override
        public short[] getLineBreakOffsets() {
            int exclude;
            if (!this.saveLineBreakOffsets) {
                return null;
            }
            int n = exclude = this.lastOffset == this.textOffset ? 1 : 0;
            if (this.lineBreakOffsets == null || this.lineBreakOffsets.size() <= exclude) {
                return JRPrintText.ZERO_LINE_BREAK_OFFSETS;
            }
            short[] offsets = new short[this.lineBreakOffsets.size() - exclude];
            boolean overflow = false;
            for (int i = 0; i < offsets.length; ++i) {
                int offset = this.lineBreakOffsets.get(i);
                if (offset > Short.MAX_VALUE) {
                    if (log.isWarnEnabled()) {
                        log.warn("Line break offset value " + offset + " is bigger than the maximum supported value of" + Short.MAX_VALUE + ". Line break offsets will not be saved for this text.");
                    }
                    overflow = true;
                    break;
                }
                offsets[i] = (short)offset;
            }
            if (overflow) {
                return null;
            }
            return offsets;
        }
    }
}

