/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Font;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVirtualizable;
import net.sf.jasperreports.engine.JRVirtualizationHelper;
import net.sf.jasperreports.engine.JRVirtualizer;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.PrintElementId;
import net.sf.jasperreports.engine.PrintElementVisitor;
import net.sf.jasperreports.engine.base.JRVirtualPrintPage;
import net.sf.jasperreports.engine.base.VirtualElementsData;
import net.sf.jasperreports.engine.base.VirtualizableElementList;
import net.sf.jasperreports.engine.fill.JRTemplateElement;
import net.sf.jasperreports.engine.fill.JRTemplatePrintElement;
import net.sf.jasperreports.engine.fill.VirtualizationContextIdHolder;
import net.sf.jasperreports.engine.fill.VirtualizationListener;
import net.sf.jasperreports.engine.fonts.FontUtil;
import net.sf.jasperreports.engine.util.DeepPrintElementVisitor;
import net.sf.jasperreports.engine.util.UniformPrintElementVisitor;
import net.sf.jasperreports.renderers.Renderable;
import org.apache.commons.collections4.map.AbstractReferenceMap;
import org.apache.commons.collections4.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRVirtualizationContext
implements Serializable,
VirtualizationListener<VirtualElementsData> {
    private static final long serialVersionUID = 10200L;
    public static final String EXCEPTION_MESSAGE_KEY_LOCKING_INTERRUPTED = "fill.virtualizer.locking.interrupted";
    public static final String EXCEPTION_MESSAGE_KEY_RENDERER_NOT_FOUND_IN_CONTEXT = "fill.virtualizer.renderer.not.found.in.context";
    public static final String EXCEPTION_MESSAGE_KEY_TEMPLATE_NOT_FOUND_IN_CONTEXT = "fill.virtualizer.template.not.found.in.context";
    private static final Log log = LogFactory.getLog(JRVirtualizationContext.class);
    private static final ReferenceMap<JasperPrint, JRVirtualizationContext> contexts = new ReferenceMap(AbstractReferenceMap.ReferenceStrength.WEAK, AbstractReferenceMap.ReferenceStrength.WEAK);
    private UUID id = UUID.randomUUID();
    private boolean root;
    private transient JRVirtualizationContext parentContext;
    private transient JRVirtualizer virtualizer;
    private transient JasperReportsContext jasperReportsContext;
    private Map<String, Renderable> cachedRenderers;
    private Map<String, JRTemplateElement> cachedTemplates;
    private Map<UUID, JRVirtualizationContext> subContexts;
    private transient Set<JRVirtualizationContext> frameContexts;
    private transient Map<PrintElementId, VirtualizableElementList> virtualizableLists;
    private volatile boolean readOnly;
    private volatile boolean disposed;
    private int pageElementSize;
    private transient List<VirtualizationListener<VirtualElementsData>> listeners;
    private volatile transient PrintElementVisitor<Void> cacheTemplateVisitor;
    private transient ReentrantLock lock;

    public JRVirtualizationContext(JasperReportsContext jasperReportsContext) {
        this.root = true;
        this.jasperReportsContext = jasperReportsContext;
        this.cachedRenderers = new ConcurrentHashMap<String, Renderable>(16, 0.75f, 1);
        this.cachedTemplates = new ConcurrentHashMap<String, JRTemplateElement>(16, 0.75f, 1);
        this.virtualizableLists = new ConcurrentHashMap<PrintElementId, VirtualizableElementList>(16, 0.75f, 1);
        this.subContexts = new ConcurrentHashMap<UUID, JRVirtualizationContext>(16, 0.75f, 1);
        this.subContexts.put(this.id, this);
        this.pageElementSize = JRPropertiesUtil.getInstance(jasperReportsContext).getIntegerProperty("net.sf.jasperreports.virtual.page.element.size", 0);
        this.initLock();
        if (log.isDebugEnabled()) {
            log.debug("created " + this.id);
        }
    }

    protected JRVirtualizationContext(JRVirtualizationContext parentContext) {
        this.root = false;
        this.parentContext = parentContext;
        this.virtualizer = parentContext.virtualizer;
        this.jasperReportsContext = parentContext.jasperReportsContext;
        this.cachedRenderers = parentContext.cachedRenderers;
        this.cachedTemplates = parentContext.cachedTemplates;
        this.virtualizableLists = parentContext.virtualizableLists;
        this.subContexts = new ConcurrentHashMap<UUID, JRVirtualizationContext>(16, 0.75f, 1);
        this.subContexts.put(this.id, this);
        this.pageElementSize = parentContext.pageElementSize;
        this.lock = parentContext.lock;
        if (log.isDebugEnabled()) {
            log.debug("created sub context " + this.id + ", parent " + parentContext.id);
        }
    }

    private void initLock() {
        this.lock = new ReentrantLock(true);
    }

    public void addListener(VirtualizationListener<VirtualElementsData> listener) {
        if (this.listeners == null) {
            this.listeners = new CopyOnWriteArrayList<VirtualizationListener<VirtualElementsData>>();
        }
        this.listeners.add(listener);
        if (this.frameContexts != null) {
            for (JRVirtualizationContext frameContext : this.frameContexts) {
                frameContext.addListener(listener);
            }
        }
    }

    public void removeListener(VirtualizationListener<VirtualElementsData> listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
        if (this.frameContexts != null) {
            for (JRVirtualizationContext frameContext : this.frameContexts) {
                frameContext.removeListener(listener);
            }
        }
    }

    @Override
    public void beforeExternalization(JRVirtualizable<VirtualElementsData> object) {
        if (this.listeners != null) {
            for (VirtualizationListener<VirtualElementsData> listener : this.listeners) {
                listener.beforeExternalization(object);
            }
        }
    }

    public void afterExternalization(JRVirtualizable<VirtualElementsData> object) {
    }

    @Override
    public void afterInternalization(JRVirtualizable<VirtualElementsData> object) {
        if (this.listeners != null) {
            for (VirtualizationListener<VirtualElementsData> listener : this.listeners) {
                listener.afterInternalization(object);
            }
        }
    }

    public void cacheRenderer(Renderable renderer) {
        if (renderer != null) {
            this.cachedRenderers.put(renderer.getId(), renderer);
        }
    }

    public Renderable getCachedRenderer(String id) {
        return this.cachedRenderers.get(id);
    }

    public boolean hasCachedRenderer(String id) {
        return this.cachedRenderers.containsKey(id);
    }

    public boolean hasCachedTemplate(String id) {
        return this.cachedTemplates.containsKey(id);
    }

    public void cacheTemplate(JRTemplateElement template) {
        JRTemplateElement old = this.cachedTemplates.put(template.getId(), template);
        if (old == null && log.isDebugEnabled()) {
            log.debug("Cached template " + template + " having id " + template.getId());
        }
    }

    public JRTemplateElement getCachedTemplate(String templateId) {
        return this.cachedTemplates.get(templateId);
    }

    public void cacheTemplate(JRPrintElement element) {
        if (this.cacheTemplateVisitor == null) {
            this.cacheTemplateVisitor = new CacheTemplateVisitor();
        }
        element.accept(this.cacheTemplateVisitor, null);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(JRVirtualizationContext context, JasperPrint print) {
        ReferenceMap<JasperPrint, JRVirtualizationContext> referenceMap = contexts;
        synchronized (referenceMap) {
            contexts.put(print, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JRVirtualizationContext getRegistered(JasperPrint print) {
        ReferenceMap<JasperPrint, JRVirtualizationContext> referenceMap = contexts;
        synchronized (referenceMap) {
            return (JRVirtualizationContext)contexts.get(print);
        }
    }

    public int getPageElementSize() {
        return this.pageElementSize;
    }

    public void setPageElementSize(int pageElementSize) {
        this.pageElementSize = pageElementSize;
    }

    public JRVirtualizer getVirtualizer() {
        return this.virtualizer;
    }

    public void setVirtualizer(JRVirtualizer virtualizer) {
        this.virtualizer = virtualizer;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.setThreadJasperReportsContext();
        ObjectInputStream.GetField fields = in.readFields();
        this.root = fields.get("root", false);
        this.cachedRenderers = (Map)fields.get("cachedRenderers", null);
        this.cachedTemplates = (Map)fields.get("cachedTemplates", null);
        this.subContexts = (Map)fields.get("subContexts", null);
        this.readOnly = fields.get("readOnly", false);
        this.pageElementSize = fields.get("pageElementSize", JRPropertiesUtil.getInstance(this.jasperReportsContext).getIntegerProperty("net.sf.jasperreports.virtual.page.element.size", 0));
        this.setThreadVirtualizer();
        this.initLock();
        if (this.root) {
            this.virtualizableLists = new ConcurrentHashMap<PrintElementId, VirtualizableElementList>(16, 0.75f, 1);
            this.subContexts.values().stream().forEach(context -> {
                context.virtualizableLists = this.virtualizableLists;
            });
        }
    }

    private void setThreadVirtualizer() {
        JRVirtualizer threadVirtualizer = JRVirtualizationHelper.getThreadVirtualizer();
        if (threadVirtualizer != null) {
            this.virtualizer = threadVirtualizer;
        }
    }

    private void setThreadJasperReportsContext() {
        JasperReportsContext threadJasperReportsContext = JRVirtualizationHelper.getThreadJasperReportsContext();
        if (threadJasperReportsContext != null) {
            this.jasperReportsContext = threadJasperReportsContext;
        } else if (this.jasperReportsContext == null) {
            if (log.isDebugEnabled()) {
                log.debug("no thread JRContext, using default");
            }
            this.jasperReportsContext = DefaultJasperReportsContext.getInstance();
        }
    }

    protected void traverseDeepElements(PrintElementVisitor<Void> visitor, Collection<? extends JRPrintElement> elements) {
        DeepPrintElementVisitor<Void> deepVisitor = new DeepPrintElementVisitor<Void>(visitor);
        for (JRPrintElement jRPrintElement : elements) {
            jRPrintElement.accept(deepVisitor, null);
        }
    }

    public Object replaceSerializedObject(Object obj) {
        Object replace = obj;
        if (obj instanceof JRTemplateElement) {
            JRTemplateElement template = (JRTemplateElement)obj;
            String templateId = template.getId();
            if (this.hasCachedTemplate(templateId)) {
                replace = new JRVirtualPrintPage.JRIdHolderTemplateElement(templateId);
            } else if (log.isDebugEnabled()) {
                log.debug("Template " + template + " having id " + template.getId() + " not found in virtualization context cache");
            }
        } else if (obj instanceof Renderable) {
            Renderable renderer = (Renderable)obj;
            if (this.hasCachedRenderer(renderer.getId())) {
                replace = new JRVirtualPrintPage.JRIdHolderRenderer(renderer);
            }
        } else if (obj instanceof JRVirtualizationContext) {
            JRVirtualizationContext context = (JRVirtualizationContext)obj;
            if (this.subContexts.containsKey(context.id)) {
                replace = new VirtualizationContextIdHolder(context.id);
            } else if (log.isDebugEnabled()) {
                log.debug("Context " + context.id + " not found under " + this.id);
            }
        }
        return replace;
    }

    public Object resolveSerializedObject(Object obj) {
        Object resolve = obj;
        if (obj instanceof JRVirtualPrintPage.JRIdHolderTemplateElement) {
            JRVirtualPrintPage.JRIdHolderTemplateElement template = (JRVirtualPrintPage.JRIdHolderTemplateElement)obj;
            JRTemplateElement cachedTemplate = this.getCachedTemplate(template.getId());
            if (cachedTemplate == null) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_TEMPLATE_NOT_FOUND_IN_CONTEXT, template.getId());
            }
            resolve = cachedTemplate;
        } else if (obj instanceof JRVirtualPrintPage.JRIdHolderRenderer) {
            JRVirtualPrintPage.JRIdHolderRenderer renderer = (JRVirtualPrintPage.JRIdHolderRenderer)obj;
            Renderable cachedRenderer = this.getCachedRenderer(renderer.getId());
            if (cachedRenderer == null) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_RENDERER_NOT_FOUND_IN_CONTEXT, renderer.getId());
            }
            resolve = cachedRenderer;
        } else if (obj instanceof VirtualizationContextIdHolder) {
            UUID id = ((VirtualizationContextIdHolder)obj).getId();
            JRVirtualizationContext context = this.subContexts.get(id);
            if (context == null) {
                throw new JRRuntimeException("Context with ID " + id + " not found");
            }
            resolve = context;
        } else if (obj instanceof Font) {
            resolve = FontUtil.getInstance(this.jasperReportsContext).resolveDeserializedFont((Font)obj);
        }
        return resolve;
    }

    public void lock() {
        try {
            this.lock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_LOCKING_INTERRUPTED, null, e);
        }
    }

    public boolean tryLock() {
        return this.lock.tryLock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public void dispose() {
        this.disposed = true;
    }

    public boolean isDisposed() {
        return this.disposed || this.parentContext != null && this.parentContext.isDisposed();
    }

    public JRVirtualizationContext getMasterContext() {
        JRVirtualizationContext context = this;
        while (context.parentContext != null) {
            context = context.parentContext;
        }
        return context;
    }

    public Map<String, Renderable> getCachedRenderers() {
        return this.cachedRenderers;
    }

    public Map<String, JRTemplateElement> getCachedTemplates() {
        return this.cachedTemplates;
    }

    public JRVirtualizationContext getFramesContext() {
        JRVirtualizationContext frameContext;
        if (this.frameContexts == null) {
            this.frameContexts = new HashSet<JRVirtualizationContext>();
        }
        if (this.frameContexts.isEmpty()) {
            frameContext = new JRVirtualizationContext(this);
            frameContext.subContexts = this.subContexts;
            this.subContexts.put(frameContext.id, frameContext);
            if (this.listeners != null) {
                for (VirtualizationListener<VirtualElementsData> listener : this.listeners) {
                    frameContext.addListener(listener);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug(this.id + " created frames context " + frameContext.id);
            }
            this.frameContexts.add(frameContext);
        } else {
            frameContext = this.frameContexts.iterator().next();
        }
        return frameContext;
    }

    public Map<PrintElementId, VirtualizableElementList> getVirtualizableLists() {
        return this.virtualizableLists;
    }

    public void cacheVirtualizableList(PrintElementId id, VirtualizableElementList virtualizableList) {
        this.virtualizableLists.put(id, virtualizableList);
    }

    public VirtualizableElementList getVirtualizableList(PrintElementId id) {
        return this.virtualizableLists.get(id);
    }

    public void updateParent(JRVirtualizationContext destinationContext) {
        destinationContext.subContexts.put(this.id, this);
        if (destinationContext.listeners != null) {
            for (VirtualizationListener<VirtualElementsData> listener : destinationContext.listeners) {
                if (this.listeners != null && this.listeners.contains(listener)) continue;
                this.addListener(listener);
            }
        }
    }

    public JasperReportsContext getJasperReportsContext() {
        return this.jasperReportsContext;
    }

    class CacheTemplateVisitor
    extends UniformPrintElementVisitor<Void> {
        public CacheTemplateVisitor() {
            super(true);
        }

        @Override
        protected void visitFrameElements(List<JRPrintElement> elements, Void v) {
            if (!(elements instanceof VirtualizableElementList)) {
                super.visitFrameElements(elements, v);
            }
        }

        @Override
        protected void visitElement(JRPrintElement element, Void arg) {
            JRTemplatePrintElement templateElement;
            JRTemplateElement template;
            if (element instanceof JRTemplatePrintElement && (template = (templateElement = (JRTemplatePrintElement)element).getTemplate()) != null) {
                JRVirtualizationContext.this.cacheTemplate(template);
            }
        }
    }
}

