/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.io.Writer;
import java.util.Map;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import org.apache.commons.collections4.map.AbstractReferenceMap;
import org.apache.commons.collections4.map.ReferenceMap;

public class XlsxSharedStringsHelper
extends BaseHelper {
    private int count = 0;
    private Map<String, Integer> sharedStrings = new ReferenceMap<String, Integer>(AbstractReferenceMap.ReferenceStrength.SOFT, AbstractReferenceMap.ReferenceStrength.HARD);

    public XlsxSharedStringsHelper(JasperReportsContext jasperReportsContext, Writer writer, String exporterKey) {
        super(jasperReportsContext, writer);
    }

    public void exportHeader() {
        this.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n");
        this.write("<sst xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\">\n");
    }

    public int export(String value) {
        Integer index = this.sharedStrings.get(value);
        if (index == null) {
            this.write("<si>");
            this.write(value);
            this.write("</si>\n");
            index = this.count++;
            this.sharedStrings.put(value, index);
        }
        return index;
    }

    public void exportFooter() {
        this.write("</sst>");
    }
}

