/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.io.IOException;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.PrintPageFormat;
import net.sf.jasperreports.engine.export.Cut;
import net.sf.jasperreports.engine.export.CutsInfo;
import net.sf.jasperreports.engine.export.GenericElementCsvHandler;
import net.sf.jasperreports.engine.export.GenericElementHandlerEnviroment;
import net.sf.jasperreports.engine.export.Grid;
import net.sf.jasperreports.engine.export.GridRow;
import net.sf.jasperreports.engine.export.JRAbstractCsvExporter;
import net.sf.jasperreports.engine.export.JRCsvExporterContext;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRGridLayout;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.export.CsvExporterConfiguration;
import net.sf.jasperreports.export.CsvReportConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRCsvExporter
extends JRAbstractCsvExporter<CsvReportConfiguration, CsvExporterConfiguration, JRCsvExporterContext> {
    private static final Log log = LogFactory.getLog(JRCsvExporter.class);

    public JRCsvExporter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public JRCsvExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
        this.exporterContext = new ExporterContext();
    }

    @Override
    protected Class<CsvExporterConfiguration> getConfigurationInterface() {
        return CsvExporterConfiguration.class;
    }

    @Override
    protected Class<CsvReportConfiguration> getItemConfigurationInterface() {
        return CsvReportConfiguration.class;
    }

    @Override
    protected void exportPage(JRPrintPage page) throws IOException {
        CsvReportConfiguration lcItemConfiguration = (CsvReportConfiguration)this.getCurrentItemConfiguration();
        PrintPageFormat pageFormat = this.jasperPrint.getPageFormat(this.pageIndex);
        JRGridLayout layout = new JRGridLayout(this.nature, page.getElements(), (int)pageFormat.getPageWidth(), (int)pageFormat.getPageHeight(), lcItemConfiguration.getOffsetX() == null ? 0 : lcItemConfiguration.getOffsetX(), lcItemConfiguration.getOffsetY() == null ? 0 : lcItemConfiguration.getOffsetY(), null);
        Grid grid = layout.getGrid();
        CutsInfo xCuts = layout.getXCuts();
        CutsInfo yCuts = layout.getYCuts();
        StringBuilder rowBuilder = null;
        boolean isFirstColumn = true;
        int rowCount = grid.getRowCount();
        for (int y = 0; y < rowCount; ++y) {
            Cut yCut = yCuts.getCut(y);
            rowBuilder = new StringBuilder();
            if (!yCut.isCutNotEmpty()) continue;
            isFirstColumn = true;
            GridRow row = grid.getRow(y);
            int rowSize = row.size();
            for (int x = 0; x < rowSize; ++x) {
                JRPrintElement element = row.get(x).getElement();
                if (element != null) {
                    String text = null;
                    if (element instanceof JRPrintText) {
                        JRStyledText styledText = this.getStyledText((JRPrintText)element);
                        text = styledText == null ? "" : styledText.getText();
                    } else if (element instanceof JRGenericPrintElement) {
                        JRGenericPrintElement genericPrintElement = (JRGenericPrintElement)element;
                        GenericElementCsvHandler handler = (GenericElementCsvHandler)GenericElementHandlerEnviroment.getInstance(this.getJasperReportsContext()).getElementHandler(genericPrintElement.getGenericType(), "net.sf.jasperreports.csv");
                        if (handler == null) {
                            if (log.isDebugEnabled()) {
                                log.debug("No CSV generic element handler for " + genericPrintElement.getGenericType());
                            }
                            text = "";
                        } else {
                            text = handler.getTextValue((JRCsvExporterContext)this.exporterContext, genericPrintElement);
                        }
                    }
                    if (text == null) continue;
                    if (!isFirstColumn) {
                        rowBuilder.append(this.fieldDelimiter);
                    }
                    rowBuilder.append(this.prepareText(text));
                    isFirstColumn = false;
                    continue;
                }
                if (!xCuts.getCut(x).isCutNotEmpty()) continue;
                if (!isFirstColumn) {
                    rowBuilder.append(this.fieldDelimiter);
                }
                isFirstColumn = false;
            }
            if (rowBuilder.length() <= 0) continue;
            this.writer.write(rowBuilder.toString());
            this.writer.write(this.recordDelimiter);
        }
        JRExportProgressMonitor progressMonitor = lcItemConfiguration.getProgressMonitor();
        if (progressMonitor != null) {
            progressMonitor.afterPageExport();
        }
    }

    protected class ExporterContext
    extends JRAbstractExporter.BaseExporterContext
    implements JRCsvExporterContext {
        protected ExporterContext() {
            super(JRCsvExporter.this);
        }
    }
}

