/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import com.fasterxml.jackson.annotation.JsonCreator;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRVisitable;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.component.BaseComponentContext;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ContextAwareComponent;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRDesignComponentElement
extends JRDesignElement
implements JRComponentElement {
    private static final long serialVersionUID = 10200L;
    private static final Log log = LogFactory.getLog(JRDesignComponentElement.class);
    public static final String PROPERTY_COMPONENT = "component";
    private Component component;
    private transient JRPropertyChangeSupport eventSupport;

    @JsonCreator
    public JRDesignComponentElement() {
        this(JasperDesign.getThreadInstance());
    }

    public JRDesignComponentElement(JRDefaultStyleProvider defaultStyleProvider) {
        super(defaultStyleProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JRPropertyChangeSupport getEventSupport() {
        JRDesignComponentElement jRDesignComponentElement = this;
        synchronized (jRDesignComponentElement) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void visit(JRVisitor visitor) {
        visitor.visitComponentElement(this);
        if (this.component instanceof JRVisitable) {
            ((JRVisitable)((Object)this.component)).visit(visitor);
        }
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        Component old = this.component;
        this.component = component;
        this.setComponentContext();
        this.getEventSupport().firePropertyChange(PROPERTY_COMPONENT, old, this.component);
    }

    protected void setComponentContext() {
        if (this.component instanceof ContextAwareComponent) {
            ContextAwareComponent contextAwareComponent = (ContextAwareComponent)this.component;
            BaseComponentContext context = new BaseComponentContext();
            context.setComponentElement(this);
            contextAwareComponent.setContext(context);
        }
    }

    @Override
    public Object clone() {
        JRDesignComponentElement clone = (JRDesignComponentElement)super.clone();
        if (this.component instanceof JRCloneable) {
            clone.component = (Component)((JRCloneable)((Object)this.component)).clone();
            clone.setComponentContext();
        } else if (this.component != null && log.isDebugEnabled()) {
            log.debug("Component of type " + this.component.getClass().getName() + " does not implement JRCloneable, not cloning");
        }
        clone.eventSupport = null;
        return clone;
    }
}

