/*
 * Decompiled with CFR 0.152.
 */
package eu.client.cloudlinker;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import eu.client.cloudlinker.ClientHttpResponse;
import java.io.BufferedInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Iterator;
import java.util.Map;

public class HttpService {
    public String performHttpRequest(String url, String method, String body, String username, String password) throws Exception {
        HttpClient client = HttpClient.newHttpClient();
        URI uri = URI.create(url);
        String credentials = username + ":" + password;
        String encodedAuth = Base64.getEncoder().encodeToString(credentials.getBytes());
        System.out.println("Posting to uri:" + url);
        HttpRequest request = HttpRequest.newBuilder().uri(uri).POST(HttpRequest.BodyPublishers.ofString(body)).header("Authorization", "Basic " + encodedAuth).header("Content-Type", "application/json").header("Accept", "application/json").build();
        HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() == 200) {
            return response.body();
        }
        System.err.println("Fout bij aanmaken client_id: HTTP " + response.statusCode());
        System.err.println("Respons: " + response.body());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performHttpDownload(String url, String filename) {
        boolean result;
        HttpURLConnection connection = null;
        try (BufferedInputStream in = new BufferedInputStream(new URL(url).openStream());
             FileOutputStream fileOutputStream = new FileOutputStream(filename);){
            int bytesRead;
            byte[] dataBuffer = new byte[1024];
            while ((bytesRead = in.read(dataBuffer, 0, 1024)) != -1) {
                fileOutputStream.write(dataBuffer, 0, bytesRead);
            }
            System.out.println("Download voltooid: " + filename);
            result = true;
        }
        catch (IOException e) {
            System.err.println("Fout tijdens downloaden: " + e.getMessage());
            result = false;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return result;
    }

    public ClientHttpResponse performClientRequest(String http_target_url, String http_method, ObjectNode http_headers, ObjectNode http_parameters, String http_authentication, String http_username, String http_password, String http_bearer_token) throws Exception {
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest.Builder builder = HttpRequest.newBuilder();
        ObjectMapper mapper = new ObjectMapper();
        builder.header("Content-Type", "application/json");
        if (http_headers != null) {
            Object fields = http_headers.fields();
            while (fields.hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                builder.header((String)field.getKey(), ((JsonNode)field.getValue()).toString());
            }
        }
        switch (http_method) {
            case "GET": {
                System.out.println("GET request");
                String full_url = http_target_url + "?";
                Iterator<Map.Entry<String, JsonNode>> fields = http_parameters.fields();
                while (fields.hasNext()) {
                    Map.Entry<String, JsonNode> field = fields.next();
                    String key = URLEncoder.encode(field.getKey(), StandardCharsets.UTF_8);
                    String value = URLEncoder.encode(field.getValue().asText(), StandardCharsets.UTF_8);
                    full_url = full_url + key + "=" + value;
                    if (!fields.hasNext()) continue;
                    full_url = full_url + "&";
                }
                builder.uri(URI.create(full_url));
                builder.GET();
                break;
            }
            case "POST": {
                builder.uri(URI.create(http_target_url));
                System.out.println("POST request");
                builder.POST(HttpRequest.BodyPublishers.ofString(mapper.writeValueAsString(http_parameters)));
            }
        }
        switch (http_authentication) {
            case "none": {
                break;
            }
            case "basic": {
                String credentials = http_username + ":" + http_password;
                String encodedAuth = Base64.getEncoder().encodeToString(credentials.getBytes());
                builder.header("Authorization", "Basic " + encodedAuth);
                break;
            }
            case "bearer": {
                builder.header("Authorization", "Bearer " + http_bearer_token);
            }
        }
        HttpRequest request = builder.build();
        HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
        return new ClientHttpResponse(response.statusCode(), response.body());
    }
}

