/*
 * Decompiled with CFR 0.152.
 */
package eu.client.cloudlinker;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class Configuration {
    private static final String CONFIG_FILE = "config.properties";
    private File configFile = new File("config.properties");
    private Properties config = new Properties();

    public Configuration() {
        this.readConfiguration();
    }

    public void readConfiguration() {
        try {
            if (!this.configFile.exists()) {
                this.configFile.createNewFile();
            }
            try (FileInputStream in = new FileInputStream(CONFIG_FILE);){
                this.config.load(in);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveConfiguration() {
        try (FileOutputStream out = new FileOutputStream(CONFIG_FILE);){
            this.config.store(out, "Cloudlinker Client Configuration");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void setProperty(String name, String value) {
        this.config.setProperty(name, value);
    }

    public String getProperty(String name) {
        return this.config.getProperty(name, "").trim();
    }
}

