/*
 * Decompiled with CFR 0.152.
 */
package eu.client.cloudlinker;

import eu.client.cloudlinker.Client;
import eu.client.cloudlinker.Configuration;
import eu.client.cloudlinker.HttpService;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URISyntaxException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class Cloudlinker {
    public Configuration config = new Configuration();
    public HttpService http_service = new HttpService();
    public Client client;

    public static void main(String[] args) {
        Cloudlinker client = new Cloudlinker();
        client.start();
    }

    public void start() {
        try {
            boolean guiAvailable;
            boolean traySupported = SystemTray.isSupported();
            boolean bl = guiAvailable = !GraphicsEnvironment.isHeadless();
            if (traySupported) {
                this.startSystemTray();
            }
            String organization_id = this.config.getProperty("organization_id");
            String api_key = this.config.getProperty("api_key");
            if (organization_id.isEmpty() || api_key.isEmpty()) {
                if (guiAvailable) {
                    this.showConfigGui();
                } else {
                    System.out.println("No GUI available. Please put 'organization_id' and 'api_key' manually in configuration.properties");
                }
            } else {
                this.startMqttClient();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void startSystemTray() {
        if (!SystemTray.isSupported()) {
            System.out.println("System tray is not supported.");
        } else {
            SystemTray tray = SystemTray.getSystemTray();
            BufferedImage image = null;
            try {
                File jarFile = new File(Cloudlinker.class.getProtectionDomain().getCodeSource().getLocation().toURI());
                File jarDir = jarFile.isDirectory() ? jarFile : jarFile.getParentFile();
                File iconFile = new File(jarDir, "cloudlinker.png");
                if (!iconFile.exists()) {
                    iconFile = new File(jarDir, "cloudlinker.ico");
                }
                if (iconFile.exists()) {
                    image = ImageIO.read(iconFile);
                }
            }
            catch (URISyntaxException e2) {
                System.err.println("Could not determine JAR location: " + e2.getMessage());
            }
            catch (Exception e3) {
                System.err.println("Could not load icon: " + e3.getMessage());
            }
            if (image == null) {
                BufferedImage fallback = new BufferedImage(16, 16, 2);
                Graphics2D g = fallback.createGraphics();
                g.setColor(Color.BLUE);
                g.fillRect(0, 0, 16, 16);
                g.dispose();
                image = fallback;
            }
            PopupMenu popup = new PopupMenu();
            MenuItem configItem = new MenuItem("Show configuration");
            configItem.addActionListener(e -> this.showConfigGui());
            MenuItem exitItem = new MenuItem("Exit");
            exitItem.addActionListener(e -> System.exit(0));
            popup.add(configItem);
            popup.addSeparator();
            popup.add(exitItem);
            TrayIcon trayIcon = new TrayIcon(image, "Cloudlinker Client", popup);
            trayIcon.setImageAutoSize(true);
            try {
                tray.add(trayIcon);
            }
            catch (AWTException e4) {
                System.err.println("Could not add tray icon!");
                e4.printStackTrace();
            }
        }
    }

    private void showConfigGui() {
        String organization_id = this.config.getProperty("organization_id");
        String api_key = this.config.getProperty("api_key");
        JTextField orgIdField = new JTextField(organization_id, 30);
        JTextField apiKeyField = new JTextField(api_key, 30);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(30, 30, 30, 30));
        JPanel orgPanel = new JPanel(new FlowLayout(0));
        orgPanel.add(new JLabel("Organization ID:"));
        mainPanel.add(orgPanel);
        mainPanel.add(orgIdField);
        mainPanel.add(Box.createVerticalStrut(10));
        JPanel apiPanel = new JPanel(new FlowLayout(0));
        apiPanel.add(new JLabel("API Key:"));
        mainPanel.add(apiPanel);
        mainPanel.add(apiKeyField);
        mainPanel.add(Box.createVerticalStrut(20));
        JButton saveButton = new JButton("Save");
        JButton exitButton = new JButton("Close");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(1));
        buttonPanel.add(saveButton);
        buttonPanel.add(exitButton);
        mainPanel.add(buttonPanel);
        JDialog dialog = new JDialog((Frame)null, "Cloudlinker Client Configuration", true);
        dialog.setDefaultCloseOperation(2);
        dialog.getContentPane().add(mainPanel);
        dialog.pack();
        dialog.setLocationRelativeTo(null);
        saveButton.addActionListener(e -> {
            String orgid = orgIdField.getText().trim();
            String apikey = apiKeyField.getText().trim();
            if (orgid.isEmpty() || apikey.isEmpty()) {
                JOptionPane.showMessageDialog(dialog, "Both fields are mandatory.", "Cloudlinker Client", 0);
                return;
            }
            this.config.setProperty("organization_id", orgid);
            this.config.setProperty("api_key", apikey);
            this.config.saveConfiguration();
            dialog.dispose();
            this.startMqttClient();
        });
        exitButton.addActionListener(e -> dialog.dispose());
        dialog.setVisible(true);
    }

    public void startMqttClient() {
        this.client = new Client(this.config);
        this.client.start();
    }
}

